package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.CommonPortalManagementService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.CommonPortalManagementServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @program: markedeve-service-udp
 * @ClassName: CommonPortalManagementServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-04-12 10:41
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class CommonPortalManagementServDuImpl implements CommonPortalManagementServDu {
    private final CommonPortalManagementService commonPortalManagementService;

    @Override
    public CodeListRspBO queryCodeListByParentCodeId(CodeListByParentCodeIdReqBO reqBO) {
        log.info("-------[CommonPortalManagementServDuImpl-queryCodeListByParentCodeId]-------，入参{}", reqBO.toString());
        CodeListRspBO rspBO = new CodeListRspBO();
        try {
            rspBO = commonPortalManagementService.queryCodeListByParentCodeId(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[CommonPortalManagementServDuImpl-queryCodeListByParentCodeId]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO doAbilityUseRequestSubmit(InfoAbilityCurrencyUseReqBO reqBO) {
        log.info("-------[CommonPortalManagementServDuImpl-doAbilityUseRequestSubmit]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = commonPortalManagementService.doAbilityUseRequestSubmit(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[CommonPortalManagementServDuImpl-doAbilityUseRequestSubmit]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO doAbilityUseApprovalFinish(InfoAbilityCurrencyUseReqBO reqBO) {
        log.info("-------[CommonPortalManagementServDuImpl-doAbilityUseApprovalFinish]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = commonPortalManagementService.doAbilityUseApprovalFinish(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[CommonPortalManagementServDuImpl-doAbilityUseApprovalFinish]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO doAbilityCreateSubmit(InfoAbilityCurrencyReqBO reqBO) {
        log.info("-------[CommonPortalManagementServDuImpl-doAbilityCreateSubmit]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = commonPortalManagementService.doAbilityCreateSubmit(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[CommonPortalManagementServDuImpl-doAbilityCreateSubmit]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO doAbilityCreateFinishApproval(InfoAbilityCurrencyReqBO reqBO) {
        log.info("-------[CommonPortalManagementServDuImpl-doAbilityCreateFinishApproval]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = commonPortalManagementService.doAbilityCreateFinishApproval(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[CommonPortalManagementServDuImpl-doAbilityCreateFinishApproval]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
