package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.DemandDetailService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoDemandDetailsLogRspBO;
import com.tydic.dict.service.course.bo.InfoDemandDetailsRspBO;
import com.tydic.dict.service.course.bo.ProjectApprovalBO;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.DemandDetailServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class DemandDetailServDuImpl implements DemandDetailServDu {
    private final DemandDetailService demandDetailService;
    @Override
    public InfoDemandDetailsRspBO queryDemandByPage(ProjectApprovalBO projectApprovalBO0) {
        try{
            return demandDetailService.queryDemandByPage(projectApprovalBO0);
        }catch (Exception e){
            InfoDemandDetailsRspBO result = new InfoDemandDetailsRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public InfoDemandDetailsLogRspBO queryDemandLogByPage(ProjectApprovalBO projectApprovalBO0) {
        try{
            return demandDetailService.queryDemandLogByPage(projectApprovalBO0);
        }catch (Exception e){
            InfoDemandDetailsLogRspBO result = new InfoDemandDetailsLogRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public BaseRspBO demandMoveIn(ProjectApprovalBO projectApprovalBO0) {
        try{
            return demandDetailService.demandMoveIn(projectApprovalBO0);
        }catch (Exception e){
            BaseRspBO result = new BaseRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public BaseRspBO deleteDemand(ProjectApprovalBO projectApprovalBO0) {
        try{
            return demandDetailService.deleteDemand(projectApprovalBO0);
        }catch (Exception e){
            BaseRspBO result = new BaseRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }
}
