package com.tydic.dict.servDuImpl;

import com.alibaba.druid.util.StringUtils;
import com.tydic.dict.service.course.bo.TypeCodeAndRelevanceProjectCodeBO;
import com.tydic.dict.service.course.constants.BaseConstant;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.EncodingAutomaticGenerationServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class EncodingAutomaticGenerationServDuImpl implements EncodingAutomaticGenerationServDu {
    @Override
    public TypeCodeAndRelevanceProjectCodeBO encodingAutomaticGeneration(TypeCodeAndRelevanceProjectCodeBO typeCodeAndRelevanceProjectCodeBO0) {
        TypeCodeAndRelevanceProjectCodeBO result = new TypeCodeAndRelevanceProjectCodeBO();
        String typeCode = StringUtils.isEmpty(typeCodeAndRelevanceProjectCodeBO0.getRelevanceProjectCode())
                ?typeCodeAndRelevanceProjectCodeBO0.getTypeCode()
                : BaseConstant.typeCode;
        DateFormat df = new SimpleDateFormat("yyyyMMdd");
        String s = df.format(new Date());
        //创建Random对象
        Random random = new Random();
        // 生成四位随机数
        int number = random.nextInt(9000) + 1000;
        String autoCode = typeCode+s+number;
        result.setTypeCode(typeCode);
        result.setAutoCode(autoCode);
        result.setRelevanceProjectCode(typeCodeAndRelevanceProjectCodeBO0.getRelevanceProjectCode());
        result.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        result.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return result;
    }
}
