package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoAbilityCurrencyService;
import com.tydic.dict.service.course.bo.InfoAbilityCurrencyReqBO;
import com.tydic.dict.service.course.bo.InfoAbilityCurrencyRspBO;
import com.tydic.dict.service.course.bo.InfoAbilityCurrencyUseReqBO;
import com.tydic.dict.service.course.bo.InfoAbilityCurrencyUseRspBO;
import com.tydic.dict.service.course.servDu.InfoAbilityCurrencyServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

@HTServiceImpl
@Slf4j
public class InfoAbilityCurrencyServDuImpl implements InfoAbilityCurrencyServDu {
    @Resource
    InfoAbilityCurrencyService infoAbilityCurrencyService;

    @Resource
    InfoAbilityCurrencyService infoAbilityCurrencyUseService;

    @Override
    public InfoAbilityCurrencyRspBO queryInfoAbilityCurrencyPage(InfoAbilityCurrencyReqBO infoAbilityCurrencyReqBO) {
        log.info("-------[InfoAbilityCurrencyServDuImpl-queryInfoAbilityCurrencyPage]-------，入参{}", infoAbilityCurrencyReqBO.toString());
        InfoAbilityCurrencyRspBO result = new InfoAbilityCurrencyRspBO();
        try{
            result =infoAbilityCurrencyService.queryInfoAbilityCurrencyPage(infoAbilityCurrencyReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoAbilityCurrencyPage：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilityCurrencyServDuImpl-queryInfoAbilityCurrencyPage]-------，出参{}", result.toString());
        return result;
    }

    @Override
    public InfoAbilityCurrencyRspBO queryInfoAbilityCurrencyByIdCurrencyCodeBusiCode(InfoAbilityCurrencyReqBO infoAbilityCurrencyReqBO) {
        log.info("-------[InfoAbilityCurrencyServDuImpl-queryInfoAbilityCurrencyByIdCurrencyCodeBusiCode]-------，入参{}", infoAbilityCurrencyReqBO.toString());
        InfoAbilityCurrencyRspBO result = new InfoAbilityCurrencyRspBO();
        try{
            result =infoAbilityCurrencyService.queryInfoAbilityCurrencyByIdCurrencyCodeBusiCode(infoAbilityCurrencyReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoAbilityCurrencyByIdCurrencyCodeBusiCode：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilityCurrencyServDuImpl-queryInfoAbilityCurrencyByIdCurrencyCodeBusiCode]-------，出参{}", result.toString());
        return result;
    }

    @Override
    public InfoAbilityCurrencyRspBO queryInfoAbilityCurrencyByUseBusiCode(InfoAbilityCurrencyReqBO infoAbilityCurrencyReqBO) {
        log.info("-------[InfoAbilityCurrencyServDuImpl-queryInfoAbilityCurrencyByUseBusiCode]-------，入参{}", infoAbilityCurrencyReqBO.toString());
        InfoAbilityCurrencyRspBO result = new InfoAbilityCurrencyRspBO();
        try{
            result =infoAbilityCurrencyService.queryInfoAbilityCurrencyByUseBusiCode(infoAbilityCurrencyReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoAbilityCurrencyByUseBusiCode：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilityCurrencyServDuImpl-queryInfoAbilityCurrencyByUseBusiCode]-------，出参{}", result.toString());
        return result;
    }

    @Override
    public InfoAbilityCurrencyUseRspBO queryInfoAbilityCurrencyUseNumByAbilityCurrencyCode(InfoAbilityCurrencyUseReqBO infoAbilityCurrencyUseReqBO) {
        log.info("-------[InfoAbilityCurrencyServDuImpl-queryInfoAbilityCurrencyUseNumByAbilityCurrencyCode]-------，入参{}", infoAbilityCurrencyUseReqBO.toString());
        InfoAbilityCurrencyUseRspBO result = new InfoAbilityCurrencyUseRspBO();
        try{
            result =infoAbilityCurrencyUseService.queryInfoAbilityCurrencyUseNumByAbilityCurrencyCode(infoAbilityCurrencyUseReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoAbilityCurrencyUseNumByAbilityCurrencyCode：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilityCurrencyServDuImpl-queryInfoAbilityCurrencyUseNumByAbilityCurrencyCode]-------，出参{}", result.toString());
        return result;
    }
}
