package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoAbilitySharingHisService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.InfoAbilitySharingHisServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @program: markedeve-service-udp
 * @ClassName: InfoAbilitySharingHisServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-04-09 09:40
 */

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoAbilitySharingHisServDuImpl implements InfoAbilitySharingHisServDu {

    private final InfoAbilitySharingHisService infoAbilitySharingHisService;

    @Override
    public InfoAbilitySharingRspBO queryInfoAbilitySharingPageList(InfoAbilitySharingReqBO reqBO) {
        log.info("-------[InfoAbilitySharingHisServDuImpl-queryInfoAbilitySharingPageList]-------，入参{}", reqBO.toString());
        InfoAbilitySharingRspBO rspBO = new InfoAbilitySharingRspBO();
        try {
            rspBO = infoAbilitySharingHisService.queryInfoAbilitySharingPageList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilitySharingHisServDuImpl-queryInfoAbilitySharingPageList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoAbilitySharingRspBO queryInfoAbilitySharingGroupByAbilityType(InfoAbilitySharingReqBO reqBO) {
        log.info("-------[InfoAbilitySharingHisServDuImpl-queryInfoAbilitySharingGroupByAbilityType]-------，入参{}", reqBO.toString());
        InfoAbilitySharingRspBO rspBO = new InfoAbilitySharingRspBO();
        try {
            rspBO = infoAbilitySharingHisService.queryInfoAbilitySharingGroupByAbilityType(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilitySharingHisServDuImpl-queryInfoAbilitySharingGroupByAbilityType]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoAbilitySharingRspBO queryInfoAbilityReadAndAddStatistics(InfoAbilitySharingReqBO reqBO) {
        log.info("-------[InfoAbilitySharingHisServDuImpl-queryInfoAbilityReadAndAddStatistics]-------，入参{}", reqBO.toString());
        InfoAbilitySharingRspBO rspBO = new InfoAbilitySharingRspBO();
        try {
            rspBO = infoAbilitySharingHisService.queryInfoAbilityReadAndAddStatistics(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilitySharingHisServDuImpl-queryInfoAbilityReadAndAddStatistics]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO saveInfoAbilitySharingSubmit(InfoAbilitySharingHisReqBO reqBO) {
        log.info("-------[InfoAbilitySharingHisServDuImpl-saveInfoAbilitySharingSubmit]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoAbilitySharingHisService.saveInfoAbilitySharingSubmit(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilitySharingHisServDuImpl-saveInfoAbilitySharingSubmit]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO doInfoAbilitySharingApprove(InfoAbilitySharingReqBO reqBO) {
        log.info("-------[InfoAbilitySharingHisServDuImpl-doInfoAbilitySharingApprove]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoAbilitySharingHisService.doInfoAbilitySharingApprove(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilitySharingHisServDuImpl-doInfoAbilitySharingApprove]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
