package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoAbilitySharingService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.InfoAbilitySharingServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

@HTServiceImpl
@Slf4j
public class InfoAbilitySharingServDuImpl implements InfoAbilitySharingServDu {
    @Resource
    private InfoAbilitySharingService infoAbilitySharingService;

    @Override
    public InfoAbilitySharingRspBO queryInfoAbilitySharingPage(InfoAbilitySharingReqBO infoAbilitySharingReqBO) {
        log.info("-------[InfoAbilitySharingServDuImpl-queryInfoAbilitySharingPage]-------，入参{}", infoAbilitySharingReqBO.toString());
        InfoAbilitySharingRspBO result = new InfoAbilitySharingRspBO();
        try{
            result =infoAbilitySharingService.queryInfoAbilitySharingPage(infoAbilitySharingReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoAbilitySharingPage：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilitySharingServDuImpl-queryInfoAbilitySharingPage]-------，出参{}", result.toString());
        return result;
    }

    @Override
    public BaseRspBO deleteInfoAbilitySharingById(InfoAbilitySharingReqBO infoAbilitySharingReqBO) {
        log.info("-------[InfoAbilitySharingServDuImpl-deleteInfoAbilitySharingById]-------，入参{}", infoAbilitySharingReqBO.toString());
        BaseRspBO result = new BaseRspBO();
        try{
            result =infoAbilitySharingService.deleteInfoAbilitySharingById(infoAbilitySharingReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("deleteInfoAbilitySharingById：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilitySharingServDuImpl-deleteInfoAbilitySharingById]-------，出参{}", result.toString());
        return result;
    }

    @Override
    public BaseRspBO updateInfoAbilitySharingId(InfoAbilitySharingReqBO infoAbilitySharingReqBO) {
        log.info("-------[InfoAbilitySharingServDuImpl-updateInfoAbilitySharingId]-------，入参{}", infoAbilitySharingReqBO.toString());
        BaseRspBO result = new BaseRspBO();
        try{
            result =infoAbilitySharingService.updateInfoAbilitySharingId(infoAbilitySharingReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("updateInfoAbilitySharingId：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilitySharingServDuImpl-updateInfoAbilitySharingId]-------，出参{}", result.toString());
        return result;
    }

    @Override
    public BaseRspBO deleteInfoAbilitySharingHisById(InfoAbilitySharingHisReqBO infoAbilitySharingHisReqBO) {
        log.info("-------[InfoAbilitySharingHisServDuImpl-deleteInfoAbilitySharingHisById]-------，入参{}", infoAbilitySharingHisReqBO.toString());
        BaseRspBO result = new BaseRspBO();
        try{
            result =infoAbilitySharingService.deleteInfoAbilitySharingHisById(infoAbilitySharingHisReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("deleteInfoAbilitySharingHisById：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilitySharingHisServDuImpl-deleteInfoAbilitySharingHisById]-------，出参{}", result.toString());
        return result;
    }

    @Override
    public InfoAbilitySharingHisRspBO queryInfoAbilitySharingHisPage(InfoAbilitySharingHisReqBO infoAbilitySharingHisReqBO) {
        log.info("-------[InfoAbilitySharingHisServDuImpl-queryInfoAbilitySharingHisPage]-------，入参{}", infoAbilitySharingHisReqBO.toString());
        InfoAbilitySharingHisRspBO result = new InfoAbilitySharingHisRspBO();
        try{
            result =infoAbilitySharingService.queryInfoAbilitySharingHisPage(infoAbilitySharingHisReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoAbilitySharingHisPage：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilitySharingHisServDuImpl-queryInfoAbilitySharingHisPage]-------，出参{}", result.toString());
        return result;
    }

    @Override
    public InfoAbilitySharingHisRspBO queryInfoAbilitySharingHisById(InfoAbilitySharingHisReqBO infoAbilitySharingHisReqBO) {
        log.info("-------[InfoAbilitySharingHisServDuImpl-queryInfoAbilitySharingHisById]-------，入参{}", infoAbilitySharingHisReqBO.toString());
        InfoAbilitySharingHisRspBO result = new InfoAbilitySharingHisRspBO();
        try{
            result =infoAbilitySharingService.queryInfoAbilitySharingHisById(infoAbilitySharingHisReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoAbilitySharingHisById：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoAbilitySharingHisServDuImpl-queryInfoAbilitySharingHisById]-------，出参{}", result.toString());
        return result;
    }

    @Override
    public InfoAbilitySharingRspBO queryInfoAbilitySharingTotal(InfoAbilitySharingReqBO reqBO) {
        log.info("-------[InfoAbilitySharingHisServDuImpl-queryInfoAbilitySharingTotal]-------，入参{}", reqBO.toString());
        InfoAbilitySharingRspBO rspBO = new InfoAbilitySharingRspBO();
        try{
            rspBO =infoAbilitySharingService.queryInfoAbilitySharingTotal(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoAbilitySharingTotal：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
            rspBO.setDraftCount(0);
            rspBO.setReleasedCount(0);
            rspBO.setToBeReleasedCount(0);
        }
        log.info("-------[InfoAbilitySharingHisServDuImpl-queryInfoAbilitySharingTotal]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
