package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoDataSourceService;
import com.tydic.dict.service.course.bo.InfoDataSourceReqBO;
import com.tydic.dict.service.course.bo.InfoDataSourceRspBO;
import com.tydic.dict.service.course.servDu.InfoDataSourceServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description: TODO
 * @ClassName InfoDataSourceServDuImpl
 * @Author: WuZhiXiang
 * @Date: 2024/8/15 17:13
 * @Version: 1.0
 **/

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoDataSourceServDuImpl implements InfoDataSourceServDu {
    private final InfoDataSourceService infoDataSourceService;

    @Override
    public InfoDataSourceRspBO queryInfoDataSourcePageList(InfoDataSourceReqBO reqBO) {
        log.info("-------[InfoDataSourceServDuImpl-queryInfoDataSourcePageList]-------，入参{}", reqBO.toString());
        InfoDataSourceRspBO rspBO = new InfoDataSourceRspBO();
        try {
            rspBO = infoDataSourceService.queryInfoDataSourcePageList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoDataSourceServDuImpl-queryInfoDataSourcePageList]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
