package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoDemandDetailsUpdateService;
import com.tydic.dict.service.course.bo.InfoDemandDetailsUpdateOperationReqBO;
import com.tydic.dict.service.course.bo.InfoDemandDetailsUpdateOperationRspBO;
import com.tydic.dict.service.course.servDu.InfoDemandDetailsUpdateServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoDemandDetailsUpdateServDuImpl implements InfoDemandDetailsUpdateServDu {

    private final InfoDemandDetailsUpdateService infoDemandDetailsUpdateService;

    @Override
    public InfoDemandDetailsUpdateOperationRspBO submitInfoDemandDetails(InfoDemandDetailsUpdateOperationReqBO reqBO) {
        log.info("-------[InfoDemandDetailsUpdateServDuImpl-submitInfoDemandDetails被调用]-------，入参{}", reqBO.toString());
        InfoDemandDetailsUpdateOperationRspBO rspBO = new InfoDemandDetailsUpdateOperationRspBO();
        try {
            rspBO = infoDemandDetailsUpdateService.submitInfoDemandDetails(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return rspBO;
    }

    @Override
    public InfoDemandDetailsUpdateOperationRspBO approvalInfoDemandDetails(InfoDemandDetailsUpdateOperationReqBO reqBO) {
        log.info("-------[InfoDemandDetailsUpdateServDuImpl-approvalInfoDemandDetails被调用]-------，入参{}", reqBO.toString());
        InfoDemandDetailsUpdateOperationRspBO rspBO = new InfoDemandDetailsUpdateOperationRspBO();
        try {
            rspBO = infoDemandDetailsUpdateService.approvalInfoDemandDetails(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return rspBO;
    }
}
