package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoDemandManHourService;
import com.tydic.dict.service.course.bo.InfoDemandManHourReqBO;
import com.tydic.dict.service.course.bo.InfoDemandManHourRspBO;
import com.tydic.dict.service.course.bo.InfoExpertAssociationReqBO;
import com.tydic.dict.service.course.bo.InfoExpertAssociationRspBO;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.InfoDemandManHourServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description:
 * @Author: xsl
 * @Date: 2024/6/18 10:00
 */
@HTServiceImpl
@RequiredArgsConstructor
@Slf4j
public class InfoDemandManHourServDuImpl implements InfoDemandManHourServDu {

    private final InfoDemandManHourService infoDemandManHourService;
    @Override
    public InfoDemandManHourRspBO queryInfoDemandManHour(InfoDemandManHourReqBO reqBO) {
        try {
            return infoDemandManHourService.queryInfoDemandManHour(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("queryInfoDemandManHour调用异常：{}",e.getMessage());
            InfoDemandManHourRspBO rspBO = new InfoDemandManHourRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoDemandManHourRspBO submitInfoDemandManHour(InfoDemandManHourReqBO reqBO) {
        try {
            return infoDemandManHourService.submitInfoDemandManHour(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("submitInfoDemandManHour 调用异常：{}",e.getMessage());
            InfoDemandManHourRspBO rspBO = new InfoDemandManHourRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoExpertAssociationRspBO queryInfoExpertAssociation(InfoExpertAssociationReqBO reqBO) {
        try {
            return infoDemandManHourService.queryInfoExpertAssociation(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("queryInfoExpertAssociation 调用异常：{}",e.getMessage());
            InfoExpertAssociationRspBO rspBO = new InfoExpertAssociationRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoDemandManHourRspBO detailInfoDemandManHour(InfoDemandManHourReqBO reqBO) {
        try {
            return infoDemandManHourService.detailInfoDemandManHour(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("detailInfoDemandManHour 调用异常：{}",e.getMessage());
            InfoDemandManHourRspBO rspBO = new InfoDemandManHourRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoExpertAssociationRspBO insertInfoExpertAssociation(InfoExpertAssociationReqBO reqBO) {
        try {
            return infoDemandManHourService.insertInfoExpertAssociation(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("insertInfoExpertAssociation 调用异常：{}",e.getMessage());
            InfoExpertAssociationRspBO rspBO = new InfoExpertAssociationRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoExpertAssociationRspBO updateInfoExpertAssociation(InfoExpertAssociationReqBO reqBO) {
        try {
            return infoDemandManHourService.updateInfoExpertAssociation(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("updateInfoExpertAssociation 调用异常：{}",e.getMessage());
            InfoExpertAssociationRspBO rspBO = new InfoExpertAssociationRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }
    @Override
    public InfoDemandManHourRspBO endInfoExpertAssociation(InfoDemandManHourReqBO reqBO) {
        try {
            return infoDemandManHourService.endInfoExpertAssociation(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("endInfoExpertAssociation 调用异常：{}",e.getMessage());
            InfoDemandManHourRspBO rspBO = new InfoDemandManHourRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoDemandManHourRspBO updateInfoDemandManHour(InfoDemandManHourReqBO reqBO) {
        try {
            return infoDemandManHourService.updateInfoDemandManHour(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("updateInfoDemandManHour 调用异常：{}",e.getMessage());
            InfoDemandManHourRspBO rspBO = new InfoDemandManHourRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }
}
