package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoDemandPreReviewService;
import com.tydic.dict.service.course.bo.InfoDemandPreReviewReqBO;
import com.tydic.dict.service.course.bo.InfoDemandPreReviewRspBO;
import com.tydic.dict.service.course.bo.InfoDemandTabulationHisRspBO;
import com.tydic.dict.service.course.servDu.InfoDemandPreReviewServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @program: markedeve-service-udp
 * @ClassName: InfoDemandPreReviewServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-27 16:22
 */

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoDemandPreReviewServDuImpl implements InfoDemandPreReviewServDu {

    private final InfoDemandPreReviewService infoDemandPreReviewService;

    @Override
    public InfoDemandPreReviewRspBO queryInfoDemandPreReviewList(InfoDemandPreReviewReqBO reqBO) {
        log.info("-------[InfoDemandPreReviewServDuImpl-queryInfoDemandPreReviewList]-------，入参{}", reqBO.toString());
        InfoDemandPreReviewRspBO rspBO = new InfoDemandPreReviewRspBO();
        try {
            rspBO = infoDemandPreReviewService.queryInfoDemandPreReviewList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoDemandPreReviewServDuImpl-queryInfoDemandPreReviewList]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
