package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoDemandTabulationHisService;
import com.tydic.dict.service.course.bo.InfoDemandTabulationHisReqBO;
import com.tydic.dict.service.course.bo.InfoDemandTabulationHisRspBO;
import com.tydic.dict.service.course.bo.InfoDemandTabulationRspBO;
import com.tydic.dict.service.course.servDu.InfoDemandTabulationHisServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @program: markedeve-service-udp
 * @ClassName: InfoDemandTabulationHisServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-02-23 10:18
 */
@HTServiceImpl
@Slf4j
public class InfoDemandTabulationHisServDuImpl implements InfoDemandTabulationHisServDu {

    @Resource
    private InfoDemandTabulationHisService infoDemandTabulationHisService;

    @Override
    public InfoDemandTabulationHisRspBO queryInfoDemandTabulationHisList(InfoDemandTabulationHisReqBO reqBO) {
        log.info("-------[InfoDemandTabulationHisServDuImpl-queryInfoDemandTabulationHisList]-------，入参{}", reqBO.toString());
        InfoDemandTabulationHisRspBO rspBO = new InfoDemandTabulationHisRspBO();
        try {
            rspBO = infoDemandTabulationHisService.queryInfoDemandTabulationHisList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoDemandTabulationHisServDuImpl-queryInfoDemandTabulationHisList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoDemandTabulationHisRspBO insertInfoDemandTabulationHis(InfoDemandTabulationHisReqBO reqBO) {
        log.info("-------[InfoDemandTabulationHisServDuImpl-insertInfoDemandTabulationHis]-------，入参{}", reqBO.toString());
        InfoDemandTabulationHisRspBO rspBO = new InfoDemandTabulationHisRspBO();
        try {
            rspBO = infoDemandTabulationHisService.insertInfoDemandTabulationHis(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
        }
        log.info("-------[InfoDemandTabulationHisServDuImpl-insertInfoDemandTabulationHis]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoDemandTabulationHisRspBO deleteInfoDemandTabulationHis(InfoDemandTabulationHisReqBO reqBO) {
        log.info("-------[InfoDemandTabulationHisServDuImpl-deleteInfoDemandTabulationHis]-------，入参{}", reqBO.toString());
        InfoDemandTabulationHisRspBO rspBO = new InfoDemandTabulationHisRspBO();
        try {
            rspBO = infoDemandTabulationHisService.deleteInfoDemandTabulationHis(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
        }
        log.info("-------[InfoDemandTabulationHisServDuImpl-deleteInfoDemandTabulationHis]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
