package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoDemandTabulationService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoDemandTabulationBO;
import com.tydic.dict.service.course.bo.InfoDemandTabulationReqBO;
import com.tydic.dict.service.course.bo.InfoDemandTabulationRspBO;
import com.tydic.dict.service.course.servDu.InfoDemandTabulationServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @program: markedeve-service-udp
 * @ClassName: InfoDemandTabulationServDuImpl
 * @description: 需求功能表
 * @author: wuzhixiang
 * @create: 2024-02-20 15:50
 */
@HTServiceImpl
@Slf4j
public class InfoDemandTabulationServDuImpl implements InfoDemandTabulationServDu {

    @Resource
    private InfoDemandTabulationService infoDemandTabulationService;

    @Override
    public InfoDemandTabulationRspBO queryInfoDemandRabulationList(InfoDemandTabulationReqBO reqBO) {
        log.info("-------[InfoDemandTabulationServDuImpl-queryInfoDemandRabulationList]-------，入参{}", reqBO.toString());
        InfoDemandTabulationRspBO rspBO = new InfoDemandTabulationRspBO();
        try {
            rspBO = infoDemandTabulationService.queryInfoDemandRabulationList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoDemandTabulationServDuImpl-queryInfoDemandRabulationList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoDemandTabulationRspBO insertInfoDemandRabulation(InfoDemandTabulationReqBO reqBO) {
        log.info("-------[InfoDemandTabulationServDuImpl-insertInfoDemandRabulation]-------，入参{}", reqBO.toString());
        InfoDemandTabulationRspBO rspBO = new InfoDemandTabulationRspBO();
        try {
            rspBO = infoDemandTabulationService.insertInfoDemandRabulation(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
        }
        log.info("-------[InfoDemandTabulationServDuImpl-insertInfoDemandRabulation]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoDemandTabulationRspBO deleteInfoDemandRabulation(InfoDemandTabulationReqBO reqBO) {
        log.info("-------[InfoDemandTabulationServDuImpl-deleteInfoDemandRabulation]-------，入参{}", reqBO.toString());
        InfoDemandTabulationRspBO rspBO = new InfoDemandTabulationRspBO();
        try {
            rspBO = infoDemandTabulationService.deleteInfoDemandRabulation(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
        }
        log.info("-------[InfoDemandTabulationServDuImpl-deleteInfoDemandRabulation]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO syncDemandTabulation(InfoDemandTabulationReqBO infoDemandTabulationBO0) {
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoDemandTabulationService.syncDemandTabulation(infoDemandTabulationBO0);
        } catch (Exception e) {
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
        }
        return rspBO;
    }
}
