package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoDemandTaskPersonService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.InfoDemandTaskPersonServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description:
 * @Author: xsl
 * @Date: 2024/6/20 10:37
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoDemandTaskPersonServDuImpl implements InfoDemandTaskPersonServDu {

    private final InfoDemandTaskPersonService infoDemandTaskPersonService;

    @Override
    public InfoDemandTaskPersonRspBO insertInfoDemandTaskPersonHis(InfoDemandTaskPersonReqBO reqBO) {
        try {
            return infoDemandTaskPersonService.insertInfoDemandTaskPersonHis(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("insertInfoDemandTaskPersonHis 调用异常：{}",e.getMessage());
            InfoDemandTaskPersonRspBO rspBO = new InfoDemandTaskPersonRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoDemandTaskPersonRspBO deleteInfoDemandTaskPersonHis(InfoDemandTaskPersonReqBO reqBO) {
        try {
            return infoDemandTaskPersonService.deleteInfoDemandTaskPersonHis(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("deleteInfoDemandTaskPersonHis 调用异常：{}",e.getMessage());
            InfoDemandTaskPersonRspBO rspBO = new InfoDemandTaskPersonRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1 + ": " + e.getMessage());
            return rspBO;
        }
    }

    @Override
    public InfoDemandTaskPersonRspBO updateInfoDemandTaskPersonHis(InfoDemandTaskPersonReqBO reqBO) {
        try {
            return infoDemandTaskPersonService.updateInfoDemandTaskPersonHis(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("updateInfoDemandTaskPersonHis 调用异常：{}",e.getMessage());
            InfoDemandTaskPersonRspBO rspBO = new InfoDemandTaskPersonRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1 + ": " + e.getMessage());
            return rspBO;
        }
    }

    @Override
    public InfoDemandTaskPersonRspBO queryInfoDemandTaskPerson(InfoDemandTaskPersonReqBO reqBO) {
        try {
            return infoDemandTaskPersonService.queryInfoDemandTaskPerson(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("queryInfoDemandTaskPerson 调用异常：{}",e.getMessage());
            InfoDemandTaskPersonRspBO rspBO = new InfoDemandTaskPersonRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoDemandTaskPersonRspBO queryInfoDemandTaskPersonHis(InfoDemandTaskPersonReqBO reqBO) {
        try {
            return infoDemandTaskPersonService.queryInfoDemandTaskPersonHis(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("queryInfoDemandTaskPersonHis 调用异常：{}",e.getMessage());
            InfoDemandTaskPersonRspBO rspBO = new InfoDemandTaskPersonRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public PersonBudgetRspBO queryPersonBudget(InfoDemandTaskPersonReqBO reqBO) {
        try {
            return infoDemandTaskPersonService.queryPersonBudget(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("queryPersonBudget 调用异常：{}",e.getMessage());
            PersonBudgetRspBO rspBO = new PersonBudgetRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }
}
