package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoDemandTaskService;
import com.tydic.dict.service.course.bo.InfoDemandTaskReqBO;
import com.tydic.dict.service.course.bo.InfoDemandTaskRspBO;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.InfoDemandTaskServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description:
 * @Author: xsl
 * @Date: 2024/6/19 15:11
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoDemandTaskServDuImpl implements InfoDemandTaskServDu {

    private final InfoDemandTaskService infoDemandTaskService;
    @Override
    public InfoDemandTaskRspBO insertInfoDemandTask(InfoDemandTaskReqBO reqBO) {
        try {
            return infoDemandTaskService.insertInfoDemandTask(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("insertInfoDemandTask 调用异常：{}",e.getMessage());
            InfoDemandTaskRspBO rspBO = new InfoDemandTaskRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1 +": "+e.getMessage());
            return rspBO;
        }
    }

    @Override
    public InfoDemandTaskRspBO queryInfoDemandTask(InfoDemandTaskReqBO reqBO) {
        try {
            return infoDemandTaskService.queryInfoDemandTask(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("queryInfoDemandTask 调用异常：{}",e.getMessage());
            InfoDemandTaskRspBO rspBO = new InfoDemandTaskRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoDemandTaskRspBO detailInfoDemandTask(InfoDemandTaskReqBO reqBO) {
        try {
            return infoDemandTaskService.detailInfoDemandTask(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("detailInfoDemandTask 调用异常：{}",e.getMessage());
            InfoDemandTaskRspBO rspBO = new InfoDemandTaskRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoDemandTaskRspBO deleteInfoDemandTask(InfoDemandTaskReqBO reqBO) {
        try {
            return infoDemandTaskService.deleteInfoDemandTask(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("deleteInfoDemandTask 调用异常：{}",e.getMessage());
            InfoDemandTaskRspBO rspBO = new InfoDemandTaskRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1 + ": " + e.getMessage());
            return rspBO;
        }
    }

    @Override
    public InfoDemandTaskRspBO approvalEndInfoDemandTask(InfoDemandTaskReqBO reqBO) {
        try {
            return infoDemandTaskService.approvalEndInfoDemandTask(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("approvalEndInfoDemandTask 调用异常：{}",e.getMessage());
            InfoDemandTaskRspBO rspBO = new InfoDemandTaskRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1 + ": " + e.getMessage());
            return rspBO;
        }
    }

    @Override
    public InfoDemandTaskRspBO queryInfoDemandTaskList(InfoDemandTaskReqBO reqBO) {
        try {
            return infoDemandTaskService.queryInfoDemandTaskList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("queryInfoDemandTaskList 调用异常：{}",e.getMessage());
            InfoDemandTaskRspBO rspBO = new InfoDemandTaskRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1 + ": " + e.getMessage());
            return rspBO;
        }
    }
}
