package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoDictOrderQueryAndAddService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoDictOrderAttrBO;
import com.tydic.dict.service.course.bo.InfoDictOrderAttrRspBO;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.InfoDictOrderQueryAndAddServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoDictOrderQueryAndAddServDuImpl implements InfoDictOrderQueryAndAddServDu {
    private final InfoDictOrderQueryAndAddService infoDictOrderQueryAndAddService;
    @Override
    public BaseRspBO addDictOrder(InfoDictOrderAttrBO infoDictOrderAttrBO0) {
        try{
            return infoDictOrderQueryAndAddService.addDictOrder(infoDictOrderAttrBO0);
        }catch (Exception e){
            BaseRspBO result = new BaseRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public InfoDictOrderAttrRspBO queryDictOrder(InfoDictOrderAttrBO infoDictOrderAttrBO0) {
        try{
            return infoDictOrderQueryAndAddService.queryDictOrder(infoDictOrderAttrBO0);
        }catch (Exception e){
            InfoDictOrderAttrRspBO result = new InfoDictOrderAttrRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }
}
