package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoEfficiencyIndexService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.InfoEfficiencyIndexServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description: TODO
 * @ClassName InfoEfficiencyIndexServDuImpl
 * @Author: WuZhiXiang
 * @Date: 2024/8/16 16:14
 * @Version: 1.0
 **/
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoEfficiencyIndexServDuImpl implements InfoEfficiencyIndexServDu {
    private final InfoEfficiencyIndexService infoEfficiencyIndexService;
    @Override
    public InfoEfficiencyIndexRspBO queryInfoEfficiencyIndexPageList(InfoEfficiencyIndexReqBO reqBO) {
        log.info("-------[InfoEfficiencyIndexServDuImpl-queryInfoEfficiencyIndexPageList]-------，入参{}", reqBO.toString());
        InfoEfficiencyIndexRspBO rspBO = new InfoEfficiencyIndexRspBO();
        try {
            rspBO = infoEfficiencyIndexService.queryInfoEfficiencyIndexPageList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoEfficiencyIndexServDuImpl-queryInfoEfficiencyIndexPageList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO addInfoEfficiencyIndex(InfoEfficiencyIndexReqBO reqBO) {
        log.info("-------[InfoEfficiencyIndexServDuImpl-addInfoEfficiencyIndex]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoEfficiencyIndexService.addInfoEfficiencyIndex(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoEfficiencyIndexServDuImpl-addInfoEfficiencyIndex]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO editInfoEfficiencyIndex(InfoEfficiencyIndexReqBO reqBO) {
        log.info("-------[InfoEfficiencyIndexServDuImpl-editInfoEfficiencyIndex]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoEfficiencyIndexService.editInfoEfficiencyIndex(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoEfficiencyIndexServDuImpl-editInfoEfficiencyIndex]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoEfficiencyRuleRspBO queryIndexDetailRule(InfoEfficiencyRelevanceReqBO reqBO) {
        log.info("-------[InfoEfficiencyIndexServDuImpl-queryIndexDetailRule]-------，入参{}", reqBO.toString());
        InfoEfficiencyRuleRspBO rspBO = new InfoEfficiencyRuleRspBO();
        try {
            rspBO = infoEfficiencyIndexService.queryIndexDetailRule(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoEfficiencyIndexServDuImpl-queryIndexDetailRule]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO addInfoEfficiencyRelevance(InfoEfficiencyRelevanceReqBO reqBO) {
        log.info("-------[InfoEfficiencyIndexServDuImpl-addInfoEfficiencyRelevance]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoEfficiencyIndexService.addInfoEfficiencyRelevance(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoEfficiencyIndexServDuImpl-addInfoEfficiencyRelevance]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO editInfoEfficiencyRelevance(InfoEfficiencyRelevanceReqBO reqBO) {
        log.info("-------[InfoEfficiencyIndexServDuImpl-editInfoEfficiencyRelevance]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoEfficiencyIndexService.editInfoEfficiencyRelevance(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoEfficiencyIndexServDuImpl-editInfoEfficiencyRelevance]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO removeInfoEfficiencyRelevance(InfoEfficiencyRelevanceReqBO reqBO) {
        log.info("-------[InfoEfficiencyIndexServDuImpl-removeInfoEfficiencyRelevance]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoEfficiencyIndexService.removeInfoEfficiencyRelevance(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoEfficiencyIndexServDuImpl-removeInfoEfficiencyRelevance]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
