package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoEfficiencyRuleService;
import com.tydic.dict.service.course.bo.InfoEfficiencyIndexRspBO;
import com.tydic.dict.service.course.bo.InfoEfficiencyRelevanceReqBO;
import com.tydic.dict.service.course.bo.InfoEfficiencyRuleReqBO;
import com.tydic.dict.service.course.bo.InfoEfficiencyRuleRspBO;
import com.tydic.dict.service.course.servDu.InfoEfficiencyRuleServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description: TODO
 * @ClassName InfoEfficiencyRuleServDuImpl
 * @Author: WuZhiXiang
 * @Date: 2024/8/16 12:41
 * @Version: 1.0
 **/
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoEfficiencyRuleServDuImpl implements InfoEfficiencyRuleServDu {
    private final InfoEfficiencyRuleService infoEfficiencyRuleService;
    @Override
    public InfoEfficiencyRuleRspBO queryInfoEfficiencyRulePageList(InfoEfficiencyRuleReqBO reqBO) {
        log.info("-------[InfoEfficiencyRuleServDuImpl-queryInfoEfficiencyRulePageList]-------，入参{}", reqBO.toString());
        InfoEfficiencyRuleRspBO rspBO = new InfoEfficiencyRuleRspBO();
        try {
            rspBO = infoEfficiencyRuleService.queryInfoEfficiencyRulePageList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoEfficiencyRuleServDuImpl-queryInfoEfficiencyRulePageList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoEfficiencyIndexRspBO queryEfficiencyRuleIndexDetail(InfoEfficiencyRelevanceReqBO reqBO) {
        log.info("-------[InfoEfficiencyRuleServDuImpl-queryEfficiencyRuleIndexDetail]-------，入参{}", reqBO.toString());
        InfoEfficiencyIndexRspBO rspBO = new InfoEfficiencyIndexRspBO();
        try {
            rspBO = infoEfficiencyRuleService.queryEfficiencyRuleIndexDetail(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoEfficiencyRuleServDuImpl-queryEfficiencyRuleIndexDetail]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
