package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoFileListServive;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoDemandTabulationRspBO;
import com.tydic.dict.service.course.bo.InfoFileListReqBO;
import com.tydic.dict.service.course.bo.InfoFileListRspBO;
import com.tydic.dict.service.course.servDu.InfoFileListServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @program: markedeve-service-udp
 * @ClassName: InfoFileListServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-02-28 14:45
 */

@HTServiceImpl
@Slf4j
public class InfoFileListServDuImpl implements InfoFileListServDu {

    @Resource
    private InfoFileListServive infoFileListServive;

    @Override
    public InfoFileListRspBO queryInfoFileList(InfoFileListReqBO reqBO) {
        log.info("-------[InfoFileListServDuImpl-queryInfoFileList]-------，入参{}", reqBO.toString());
        InfoFileListRspBO rspBO = new InfoFileListRspBO();
        try {
            rspBO = infoFileListServive.queryInfoFileList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoFileListServDuImpl-queryInfoFileList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO insertInfoFileList(InfoFileListReqBO reqBO) {
        log.info("-------[InfoFileListServDuImpl-insertInfoFileList]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoFileListServive.insertInfoFileList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + ":" + e.getMessage());
        }
        log.info("-------[InfoFileListServDuImpl-insertInfoFileList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoFileListRspBO qryFileListWithConclusion(InfoFileListReqBO infoFileListReqBO) {
        log.info("-------[InfoFileListServDuImpl-qryFileListWithConclusion]-------，入参{}", infoFileListReqBO.toString());
        InfoFileListRspBO rspBO = new InfoFileListRspBO();
        try {
            rspBO = infoFileListServive.qryFileListWithConclusion(infoFileListReqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + ":" + e.getMessage());
        }
        log.info("-------[InfoFileListServDuImpl-qryFileListWithConclusion]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
