package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoIndexWarnLogService;
import com.tydic.dict.service.course.bo.InfoIndexWarnLogReqBO;
import com.tydic.dict.service.course.bo.InfoIndexWarnLogRspBO;
import com.tydic.dict.service.course.servDu.InfoIndexWarnLogServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

@HTServiceImpl
@Slf4j
public class InfoIndexWarnLogServDuImpl implements InfoIndexWarnLogServDu {
    @Resource
    private InfoIndexWarnLogService infoIndexWarnLogService;

    @Override
    public InfoIndexWarnLogRspBO queryInfoIndexWarnLogList(InfoIndexWarnLogReqBO infoIndexWarnLogReqBO) {
        log.info("-------[InfoIndexWarnLogServDuImpl-queryInfoIndexWarnLogList]-------，入参{}", infoIndexWarnLogReqBO.toString());
        InfoIndexWarnLogRspBO result = new InfoIndexWarnLogRspBO();
        try{
            result =infoIndexWarnLogService.queryInfoIndexWarnLogList(infoIndexWarnLogReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoIndexWarnLogList：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoIndexWarnLogServDuImpl-queryInfoIndexWarnLogList]-------，出参{}", result.toString());
        return result;
    }
}
