package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoIndexWarnService;
import com.tydic.dict.service.course.bo.InfoIndexWarnReqBO;
import com.tydic.dict.service.course.bo.InfoIndexWarnRspBO;
import com.tydic.dict.service.course.servDu.InfoIndexWarnServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

@HTServiceImpl
@Slf4j
public class InfoIndexWarnServDuImpl implements InfoIndexWarnServDu {
    @Resource
    private InfoIndexWarnService infoIndexWarnService;
    @Override
    public InfoIndexWarnRspBO queryInfoIndexWarnByConditionPage(InfoIndexWarnReqBO infoIndexWarnReqBO) {
        log.info("-------[InfoIndexWarnServDuImpl-queryInfoIndexWarnByConditionPage]-------，入参{}", infoIndexWarnReqBO.toString());
        InfoIndexWarnRspBO result = new InfoIndexWarnRspBO();
        try{
            result =infoIndexWarnService.queryInfoIndexWarnByConditionPage(infoIndexWarnReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoIndexWarnByConditionPage：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoIndexWarnServDuImpl-queryInfoIndexWarnByConditionPage]-------，出参{}", result.toString());
        return result;
    }
}
