package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoIndexWhiteListService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoIndexWhiteListReqBO;
import com.tydic.dict.service.course.bo.InfoIndexWhiteListRspBO;
import com.tydic.dict.service.course.servDu.InfoIndexWhiteListServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

@HTServiceImpl
@Slf4j
public class InfoIndexWhiteListServDuImpl implements InfoIndexWhiteListServDu {
    @Resource
    private InfoIndexWhiteListService infoIndexWhiteListService;

    @Override
    public BaseRspBO dealInfoIndexWhiteList(InfoIndexWhiteListReqBO infoIndexWhiteListReqBO) {
        log.info("-------[InfoIndexWhiteListServDuImpl-dealInfoIndexWhiteList]-------，入参{}", infoIndexWhiteListReqBO.toString());
        BaseRspBO result = new InfoIndexWhiteListRspBO();
        try{
            result =infoIndexWhiteListService.dealInfoIndexWhiteList(infoIndexWhiteListReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("dealInfoIndexWhiteList：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoIndexWhiteListServDuImpl-dealInfoIndexWhiteList]-------，出参{}", result.toString());
        return result;
    }
}
