package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoOutsourcingFrameService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.bo.InfoOutsourcingFrameReqBO;
import com.tydic.dict.service.course.servDu.InfoOutsourcingFrameServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;
import java.util.List;

@HTServiceImpl
@Slf4j
public class InfoOutsourcingFrameServDuImpl implements InfoOutsourcingFrameServDu {

    @Resource
    InfoOutsourcingFrameService infoOutsourcingFrameService;
    @Override
    public InfoOutsourcingFrameRspBO queryInfoOutsourcingFramePage(InfoOutsourcingFrameReqBO reqBO) {

        log.info("-------[InfoOutsourcingFrameServDuImpl-queryInfoOutsourcingFramePage]-------，入参{}", reqBO.toString());
        InfoOutsourcingFrameRspBO rspBO = new InfoOutsourcingFrameRspBO();

        try{
            rspBO =infoOutsourcingFrameService.queryInfoOutsourcingFramePage(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoOutsourcingFramePage：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoOutsourcingFrameServDuImpl-queryInfoOutsourcingFramePage]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoSupplierFrameRspBO queryInfoOutsourcingFrameCondition(InfoOutsourcingFrameReqBO reqBO) {
        log.info("-------[InfoOutsourcingFrameServDuImpl-queryInfoOutsourcingFrameCondition]-------，入参{}", reqBO.toString());
        InfoSupplierFrameRspBO rspBO = new InfoSupplierFrameRspBO();

        try{
            rspBO =infoOutsourcingFrameService.queryInfoOutsourcingFrameCondition(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoOutsourcingFrameCondition：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoOutsourcingFrameServDuImpl-queryInfoOutsourcingFrameCondition]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO saveInfoOutsourcingFrame(SaveFrameReqBO reqBO) {
        log.info("-------[InfoOutsourcingFrameServDuImpl-saveInfoOutsourcingFrame]-------，入参{}", reqBO.toString());
        BaseRspBO  rspBO = new BaseRspBO ();

        try{
            rspBO =infoOutsourcingFrameService.saveInfoOutsourcingFrame(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("saveInfoOutsourcingFrame：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoOutsourcingFrameServDuImpl-saveInfoOutsourcingFrame]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public FramAmountExecutedRspBO queryFrameAmountExecuted(InfoOutsourcingFrameReqBO reqBO) {
        log.info("-------[InfoOutsourcingFrameServDuImpl-queryFrameAmountExecuted]-------，入参{}", reqBO.toString());
        FramAmountExecutedRspBO rspBO = new FramAmountExecutedRspBO();
        try{
            rspBO =infoOutsourcingFrameService.queryFrameAmountExecuted(reqBO);

        }catch (Exception e){
            e.printStackTrace();
            log.error("queryFrameAmountExecuted：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }

        log.info("-------[InfoOutsourcingFrameServDuImpl-queryFrameAmountExecuted]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
