package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoOutsourcingPersonDepoolFlowService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.InfoOutsourcingPersonDepoolFlowServDu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

/**
 * @description:
 * @author: wangchao
 * @create: 2024-06-19 17:42
 **/

@HTServiceImpl
@Slf4j
public class InfoOutsourcingPersonDepoolFlowServDuImpl implements InfoOutsourcingPersonDepoolFlowServDu {

    @Autowired
    private InfoOutsourcingPersonDepoolFlowService infoOutsourcingPersonDepoolFlowService;

    @Override
    public BaseRspBO startOutsourcingPersonDepool(OutsourcingPersonDepoolStartReqBO reqBO) {
        log.info("-----[InfoOutsourcingPersonDepoolFlowServDuImpl-startOutsourcingPersonDepool被调用，入参为：{}]-----", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        if (!StringUtils.hasText(reqBO.getPersonCode())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("人员编码不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getQuitDutyOperNo())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("出池负责人工号不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getQuitDutyOperName())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("出池负责人姓名不能为空");
            return rspBO;
        }
        try {
            rspBO = infoOutsourcingPersonDepoolFlowService.startOutsourcingPersonDepool(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-----[调用infoOutsourcingPersonDepoolFlowService服务异常，异常原因为：{}-----", e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("调用infoOutsourcingPersonDepoolFlowService服务异常，异常原因为：" + e.getMessage());
        }
        log.info("-----[InfoOutsourcingPersonDepoolFlowServDuImpl-startOutsourcingPersonDepool返回结果为：{}]-----", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO confirmOutsourcingManagement(ConfirmOutsourcingManagementReqBO reqBO) {
        log.info("-----[InfoOutsourcingPersonDepoolFlowServDuImpl-confirmOutsourcingManagement被调用，入参为：{}]-----", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        if (!StringUtils.hasText(reqBO.getTaskId())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("任务ID不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getBusiCode())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("业务编码不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getIsConfirmDepool())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("是否确认出池不能为空");
            return rspBO;
        }
        try {
            rspBO = infoOutsourcingPersonDepoolFlowService.confirmOutsourcingManagement(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-----[调用infoOutsourcingPersonDepoolFlowService服务异常，异常原因为：{}-----", e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("调用infoOutsourcingPersonDepoolFlowService服务异常，异常原因为：" + e.getMessage());
        }
        log.info("-----[InfoOutsourcingPersonDepoolFlowServDuImpl-confirmOutsourcingManagement返回结果为：{}]-----", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO confirmOutsourcingDepoolTime(ConfirmOutsourcingDepoolReqBO reqBO) {
        log.info("-----[InfoOutsourcingPersonDepoolFlowServDuImpl-confirmOutsourcingDepoolTime被调用，入参为：{}]-----", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        if (!StringUtils.hasText(reqBO.getTaskId())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("任务ID不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getBusiCode())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("业务编码不能为空");
            return rspBO;
        }
        if (null == reqBO.getQuiTime()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("预计出池时间不能为空");
            return rspBO;
        }
        try {
            rspBO = infoOutsourcingPersonDepoolFlowService.confirmOutsourcingDepoolTime(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-----[调用infoOutsourcingPersonDepoolFlowService服务异常，异常原因为：{}-----", e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("调用infoOutsourcingPersonDepoolFlowService服务异常，异常原因为：" + e.getMessage());
        }
        log.info("-----[InfoOutsourcingPersonDepoolFlowServDuImpl-confirmOutsourcingDepoolTime返回结果为：{}]-----", rspBO.toString());
        return rspBO;
    }

    @Override
    public OutsourcingPersonDepoolDetailsRspBO queryOutsourcingPersonDetails(OutsourcingPersonDepoolDetailsReqBO reqBO) {
        log.info("-----[InfoOutsourcingPersonDepoolFlowServDuImpl-queryOutsourcingPersonDetails被调用，入参为：{}]-----", reqBO.toString());
        OutsourcingPersonDepoolDetailsRspBO rspBO = new OutsourcingPersonDepoolDetailsRspBO();
        if (!StringUtils.hasText(reqBO.getBusiCode())&& !StringUtils.hasText(reqBO.getPersonCode())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("业务编码和人员编码不能同时为空");
            return rspBO;
        }
        try {
            rspBO = infoOutsourcingPersonDepoolFlowService.queryOutsourcingPersonDetails(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-----[调用infoOutsourcingPersonDepoolFlowService服务异常，异常原因为：{}-----", e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("调用infoOutsourcingPersonDepoolFlowService服务异常，异常原因为：" + e.getMessage());
        }
        log.info("-----[InfoOutsourcingPersonDepoolFlowServDuImpl-queryOutsourcingPersonDetails返回结果为：{}]-----", rspBO.toString());
        return rspBO;
    }
}
