package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoOutsourcingPersonService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.InfoOutsourcingPersonServDu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

/**
 * @description:
 * @author: wangchao
 * @create: 2024-06-18 17:08
 **/
@Slf4j
@HTServiceImpl
public class InfoOutsourcingPersonServDuImpl implements InfoOutsourcingPersonServDu {

    @Autowired
    private InfoOutsourcingPersonService infoOutsourcingPersonService;

    @Override
    public OutPersonSelectInterviewFlowRspBO submitSelectInterview(OutPersonSelectInterviewFlowReqBO reqBO) {
        log.info("-----[InfoOutsourcingPersonServDuImpl-submitSelectInterview入参为：{}]-----", reqBO.toString());
        OutPersonSelectInterviewFlowRspBO rspBO = new OutPersonSelectInterviewFlowRspBO();
        if (!StringUtils.hasText(reqBO.getBusiCode())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("流程编码不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getInterviewExpert())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("专家面试人员不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getTaskId())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("当前任务ID不能为空");
            return rspBO;
        }
        try {
            rspBO = infoOutsourcingPersonService.submitSelectInterview(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-----[调用infoOutsourcingPersonService服务异常，异常原因为：{}-----", e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("调用infoOutsourcingPersonService服务异常，异常原因为：" + e.getMessage());
        }
        log.info("-----[InfoOutsourcingPersonServDuImpl-submitSelectInterview出参为：{}]-----", reqBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO submitOutSourcingPersonApprovalRating(OutSourcingPersonApprovalRatingReqBO reqBO) {
        log.info("-----[InfoOutsourcingPersonServDuImpl-submitOutSourcingPersonApprovalRating入参为：{}]-----", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        if (!StringUtils.hasText(reqBO.getBusiCode())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("流程编码不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getOrderNo())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("订单号不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getTaskId())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("当前任务ID不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getOperationFlag())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("操作类型不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getPostLevel())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("人员级别不能为空");
            return rspBO;
        }
        try {
            rspBO = infoOutsourcingPersonService.submitOutSourcingPersonApprovalRating(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-----[调用infoOutsourcingPersonService服务异常，异常原因为：{}-----", e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("调用infoOutsourcingPersonService服务异常，异常原因为：" + e.getMessage());
        }
        log.info("-----[InfoOutsourcingPersonServDuImpl-submitOutSourcingPersonApprovalRating出参为：{}]-----", reqBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO submitSupplierUploadFile(SupplierUploadFileReqBO reqBO) {
        log.info("-----[InfoOutsourcingPersonServDuImpl-submitSupplierUploadFile入参为：{}]-----", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        if (!StringUtils.hasText(reqBO.getBusiCode())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("流程编码不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getOrderNo())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("订单号不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getTaskId())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("当前任务ID不能为空");
            return rspBO;
        }
        if (null == reqBO.getInfoFileList() || reqBO.getInfoFileList().size() == 0) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("上传文件不能为空");
        }
        try {
            rspBO = infoOutsourcingPersonService.submitSupplierUploadFile(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-----[调用infoOutsourcingPersonService服务异常，异常原因为：{}-----", e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("调用infoOutsourcingPersonService服务异常，异常原因为：" + e.getMessage());
        }
        log.info("-----[InfoOutsourcingPersonServDuImpl-submitSupplierUploadFile出参为：{}]-----", reqBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO submitAdditionalUploadFile(AdditionalUploadFileReqBO reqBO) {
        log.info("-----[InfoOutsourcingPersonServDuImpl-submitAdditionalUploadFile入参为：{}]-----", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        if (!StringUtils.hasText(reqBO.getBusiCode())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("流程编码不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getOrderNo())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("订单号不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getTaskId())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("当前任务ID不能为空");
            return rspBO;
        }
        if (null == reqBO.getInfoFileList() || reqBO.getInfoFileList().size() == 0) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("上传文件不能为空");
        }
        try {
            rspBO = infoOutsourcingPersonService.submitAdditionalUploadFile(reqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("-----[调用infoOutsourcingPersonService服务异常，异常原因为：{}-----", e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("调用infoOutsourcingPersonService服务异常，异常原因为：" + e.getMessage());
        }
        log.info("-----[InfoOutsourcingPersonServDuImpl-submitAdditionalUploadFile出参为：{}]-----", reqBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO submitFlowEnd(InfoOutsourcingPersonFlowEndReqBO reqBO) {
        log.info("-----[InfoOutsourcingPersonServDuImpl-submitFlowEnd入参为：{}]-----", reqBO.toString());
        BaseRspBO rspBO=new BaseRspBO();
        if (!StringUtils.hasText(reqBO.getBusiCode())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("流程编码不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getTaskId())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("当前任务ID不能为空");
            return rspBO;
        }
        if (!StringUtils.hasText(reqBO.getOperationFlag())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("审批结论不能为空");
            return rspBO;
        }
        try {
            rspBO = infoOutsourcingPersonService.submitFlowEnd(reqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("-----[调用infoOutsourcingPersonService服务异常，异常原因为：{}-----", e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("调用infoOutsourcingPersonService服务异常，异常原因为：" + e.getMessage());
        }
        log.info("-----[InfoOutsourcingPersonServDuImpl-submitFlowEnd出参为：{}]-----", reqBO.toString());
        return rspBO;
    }
}
