package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoOutsourcingService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.InfoOutsourcingServDu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

/**
 * @description:
 * @author: wangchao
 * @create: 2024-06-17 17:56
 **/
@HTServiceImpl
@Slf4j
public class InfoOutsourcingServDuImpl implements InfoOutsourcingServDu {

    @Autowired
    private InfoOutsourcingService infoOutsourcingService;

    @Override
    public QueryInfoOutsourcingPersonPageRspBO queryPageInfoOutsourcingPerson(QueryInfoOutsourcingPersonPageReqBO reqBO) {
        log.info("-----[InfoOutsourcingServDuImpl-queryPageInfoOutsourcingPerson被调用，入参为：{}]-----", reqBO.toString());
        QueryInfoOutsourcingPersonPageRspBO rspBO = new QueryInfoOutsourcingPersonPageRspBO();
        if (null == reqBO.getPageNo()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("页码不能为空");
            return rspBO;
        }
        if (null == reqBO.getPageSize()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("单页数据量不能为空");
            return rspBO;
        }
        try {
            rspBO = infoOutsourcingService.queryPageInfoOutsourcingPerson(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-----[调用infoOutsourcingService服务异常，异常原因为：{}-----", e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("调用infoOutsourcingService服务异常，异常原因为：" + e.getMessage());
        }
        log.info("-----[InfoOutsourcingServDuImpl-queryPageInfoOutsourcingPerson调用完成，出参为：{}]-----", rspBO.toString());
        return rspBO;
    }

    @Override
    public QueryInfoOutsourcingPersonRspBO queryInfoOutsourcingPersonDetail(QueryInfoOutsourcingPersonReqBO reqBO) {
        log.info("-----[InfoOutsourcingServDuImpl-queryInfoOutsourcingPersonDetail被调用，入参为：{}]-----", reqBO.toString());
        QueryInfoOutsourcingPersonRspBO rspBO = new QueryInfoOutsourcingPersonRspBO();
        try {
            rspBO = infoOutsourcingService.queryInfoOutsourcingPersonDetail(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-----[调用infoOutsourcingService服务异常，异常原因为：{}-----", e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("调用infoOutsourcingService服务异常，异常原因为：" + e.getMessage());
        }
        log.info("-----[InfoOutsourcingServDuImpl-queryInfoOutsourcingPersonDetail调用完成，出参为：{}]-----", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO delInfoOutsourcingPerson(QueryInfoOutsourcingPersonReqBO reqBO) {
        log.info("-----[InfoOutsourcingServDuImpl-delInfoOutsourcingPerson被调用，入参为：{}]-----", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        if (null == reqBO.getId()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("id不能为空");
            return rspBO;
        }
        try {
            rspBO = infoOutsourcingService.delInfoOutsourcingPerson(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-----[调用infoOutsourcingService服务异常，异常原因为：{}-----", e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("调用infoOutsourcingService服务异常，异常原因为：" + e.getMessage());
        }
        log.info("-----[InfoOutsourcingServDuImpl-delInfoOutsourcingPerson调用完成，出参为：{}]-----", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO saveInfoOutsourcingPerson(InsertInfoOutsourcingPersonReqBO reqBO) {
        log.info("-----[InfoOutsourcingServDuImpl-saveInfoOutsourcingPerson被调用，入参为：{}]-----", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        if (!StringUtils.hasText(reqBO.getOperateFlag())) {
            rspBO.setRespCode("9999");
            rspBO.setRespCode("操作类型不能为空");
            return rspBO;
        } else {
            if (reqBO.getOperateFlag().equals("1")) {
                if (!StringUtils.hasText(reqBO.getNextTacheDealUser())) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("下个环节处理人工号不能为空");
                    return rspBO;
                }
            }
        }
        try {
            rspBO = infoOutsourcingService.saveInfoOutsourcingPerson(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-----[调用infoOutsourcingService服务异常，异常原因为：{}-----", e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("调用infoOutsourcingService服务异常，异常原因为：" + e.getMessage());
        }
        log.info("-----[InfoOutsourcingServDuImpl-saveInfoOutsourcingPerson调用完成，出参为：{}]-----", rspBO.toString());
        return rspBO;
    }
}
