package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoPlanPrimaryHisService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoPlanPrimaryHisReqBO;
import com.tydic.dict.service.course.bo.InfoPlanPrimaryHisRspBO;
import com.tydic.dict.service.course.servDu.InfoPlanPrimaryHisServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

@HTServiceImpl
@Slf4j
public class InfoPlanPrimaryHisServDuImpl implements InfoPlanPrimaryHisServDu {

    @Resource
    InfoPlanPrimaryHisService infoPlanPrimaryHisService;

    @Override
    public InfoPlanPrimaryHisRspBO queryInfoPlanPrimaryHisPage(InfoPlanPrimaryHisReqBO reqBO) {
        log.info("-------[InfoPlanPrimaryHisServDuImpl-queryInfoPlanPrimaryHisPage]-------，入参{}", reqBO.toString());
        InfoPlanPrimaryHisRspBO rspBO = new InfoPlanPrimaryHisRspBO();

        try{
            rspBO =infoPlanPrimaryHisService.queryInfoPlanPrimaryHisPage(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoPlanPrimaryHisPage：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoPlanPrimaryHisServDuImpl-queryInfoPlanPrimaryHisPage]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO moveInfoPlanPrimaryHisByBatchNumber(InfoPlanPrimaryHisReqBO reqBO) {
        log.info("-------[InfoPlanPrimaryHisServDuImpl-moveInfoPlanPrimaryHisByBatchNumber]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();

        try{
            rspBO =infoPlanPrimaryHisService.moveInfoPlanPrimaryHisByBatchNumber(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("moveInfoPlanPrimaryHisByBatchNumber：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoPlanPrimaryHisServDuImpl-moveInfoPlanPrimaryHisByBatchNumber]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
