package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoPlanPrimaryService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.InfoPlanPrimaryServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

@HTServiceImpl
@Slf4j
public class InfoPlanPrimaryServDuImpl implements InfoPlanPrimaryServDu {

    @Resource
    InfoPlanPrimaryService infoPlanPrimaryService;

    @Override
    public InfoYearPlanRspBO queryInfoYearPlan(InfoYearPlanReqBO reqBO) {
        log.info("-------[InfoPlanPrimaryServDuImpl-queryInfoYearPlan]-------，入参{}", reqBO.toString());
        InfoYearPlanRspBO rspBO = new InfoYearPlanRspBO();

        try{
            rspBO =infoPlanPrimaryService.queryInfoYearPlan(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoYearPlan：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoPlanPrimaryServDuImpl-queryInfoYearPlan]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO submitInfoYearPlan(InfoYearPlanReqBO reqBO) {
        log.info("-------[InfoPlanPrimaryServDuImpl-submitInfoYearPlan]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();

        try{
            rspBO =infoPlanPrimaryService.submitInfoYearPlan(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("submitInfoYearPlan：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoPlanPrimaryServDuImpl-submitInfoYearPlan]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO saveInfoPlanPrimary(InfoPlanPrimaryReqBO reqBO) {
        log.info("-------[InfoPlanPrimaryServDuImpl-saveInfoPlanPrimary]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();

        try{
            rspBO =infoPlanPrimaryService.saveInfoPlanPrimary(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("saveInfoPlanPrimary：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoPlanPrimaryServDuImpl-saveInfoPlanPrimary]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO submitInfoPlanPrimary(InfoPlanPrimaryReqBO reqBO) {
        log.info("-------[InfoPlanPrimaryServDuImpl-submitInfoPlanPrimary]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();

        try{
            rspBO =infoPlanPrimaryService.submitInfoPlanPrimary(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("submitInfoPlanPrimary：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoPlanPrimaryServDuImpl-submitInfoPlanPrimary]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoPlanPrimaryRspBO queryInfoPlanPrimaryPage(InfoPlanPrimaryReqBO reqBO) {
        log.info("-------[InfoPlanPrimaryServDuImpl-queryInfoPlanPrimaryPage]-------，入参{}", reqBO.toString());
        InfoPlanPrimaryRspBO rspBO = new InfoPlanPrimaryRspBO();

        try{
            rspBO =infoPlanPrimaryService.queryInfoPlanPrimaryPage(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoPlanPrimaryPage：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoPlanPrimaryServDuImpl-queryInfoPlanPrimaryPage]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO infoPlanPrimaryApprovalFinish(InfoPlanPrimaryReqBO reqBO) {
        log.info("-------[InfoPlanPrimaryServDuImpl-infoPlanPrimaryApprovalFinish]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();

        try{
            rspBO =infoPlanPrimaryService.infoPlanPrimaryApprovalFinish(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("infoPlanPrimaryApprovalFinish：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoPlanPrimaryServDuImpl-infoPlanPrimaryApprovalFinish]-------，出参{}", rspBO.toString());
        return rspBO;
    }


    public TaskTransferRspBO reassignInfoPlanPrimary(TaskTransferReqBO reqBO) {
        log.info("-------[InfoPlanPrimaryServDuImpl-reassignInfoPlanPrimary]-------，入参{}", reqBO.toString());
        TaskTransferRspBO rspBO = new TaskTransferRspBO();

        try{
            rspBO =infoPlanPrimaryService.reassignInfoPlanPrimary(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("reassignInfoPlanPrimary：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoPlanPrimaryServDuImpl-reassignInfoPlanPrimary]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO batchApprovalInfoPlanPrimary(InfoPlanPrimaryReqBO reqBO) {
        log.info("-------[InfoPlanPrimaryServDuImpl-batchApprovalInfoPlanPrimary]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();

        try{
            rspBO =infoPlanPrimaryService.batchApprovalInfoPlanPrimary(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("batchApprovalInfoPlanPrimary：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoPlanPrimaryServDuImpl-batchApprovalInfoPlanPrimary]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public AllInfoPlanPrimaryRspBO queryAllInfoPlanPrimary(AllInfoPlanPrimaryReqBO reqBO) {
        log.info("-------[InfoPlanPrimaryServDuImpl-queryAllInfoPlanPrimary]-------，入参{}", reqBO.toString());
        AllInfoPlanPrimaryRspBO rspBO = new AllInfoPlanPrimaryRspBO();

        try{
            rspBO =infoPlanPrimaryService.queryAllInfoPlanPrimary(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryAllInfoPlanPrimary：" + e.getMessage());
            rspBO.setRspCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRspDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoPlanPrimaryServDuImpl-queryAllInfoPlanPrimary]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO infoPlanPrimaryLeaderApproval(InfoPlanPrimaryReqBO reqBO) {
        log.info("-------[InfoPlanPrimaryServDuImpl-infoPlanPrimaryLeaderApproval]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();

        try{
            rspBO =infoPlanPrimaryService.infoPlanPrimaryLeaderApproval(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("infoPlanPrimaryLeaderApproval：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoPlanPrimaryServDuImpl-infoPlanPrimaryLeaderApproval]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoYearPlanRspBO queryInfoYearPlanGroupByIndustry(InfoYearPlanReqBO reqBO) {
        log.info("-------[InfoPlanPrimaryServDuImpl-queryInfoYearPlanGroupByIndustry]-------，入参{}", reqBO.toString());
        InfoYearPlanRspBO rspBO = new InfoYearPlanRspBO();

        try{
            rspBO =infoPlanPrimaryService.queryInfoYearPlanGroupByIndustry(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoYearPlanGroupByIndustry：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoPlanPrimaryServDuImpl-queryInfoYearPlanGroupByIndustry]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
