package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoProductService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.InfoProductServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description:
 * @Author: xsl
 * @Date: 2024/2/21 15:40
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoProductServDuImpl implements InfoProductServDu {

    private final InfoProductService infoProductService;

    @Override
    public InfoMainProductListRspBO queryInfoMainProductListCatalogue(InfoMainProductListReqBO reqBO) {
        try {
            return infoProductService.queryInfoMainProductListCatalogue(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-------主产品目录查询异常：" + e.getMessage());
            InfoMainProductListRspBO rspBO = new InfoMainProductListRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL_1);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }

    }

    @Override
    public InfoSonProductListRspBO queryInfoSonProductListCatalogue(InfoMainProductListReqBO reqBO) {
        try {
            return infoProductService.queryInfoSonProductListCatalogue(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-------子产品目录查询异常：" + e.getMessage());
            InfoSonProductListRspBO rspBO = new InfoSonProductListRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL_1);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoMainProductListRspBO getInfoMainProductList(InfoMainProductListReqBO reqBO) {
        try {
            return infoProductService.getInfoMainProductList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-------主产品列表查询异常：" + e.getMessage());
            InfoMainProductListRspBO rspBO = new InfoMainProductListRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL_1);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoSonProductListRspBO getInfoSonProductList(InfoMainProductListReqBO reqBO) {
        try {
            return infoProductService.getInfoSonProductList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-------子产品列表查询异常：" + e.getMessage());
            InfoSonProductListRspBO rspBO = new InfoSonProductListRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL_1);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public BaseRspBO updateInfoProductList(InfoMainProductListReqBO reqBO) {
        try {
            return infoProductService.updateInfoProductList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-------主、子产品打标、删除统一接口异常：" + e.getMessage());
            BaseRspBO rspBO = new BaseRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL_1);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public ProductResponsibleRspBO productPersonResponsibleSearch(ProductResponsibleReqBO productResponsibleReqBO) {
        try {
            return infoProductService.productPersonResponsibleSearch(productResponsibleReqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("-------产品责任人查询接口异常：" + e.getMessage());
            ProductResponsibleRspBO rspBO = new ProductResponsibleRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL_1);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }
}
