package com.tydic.dict.servDuImpl;

import com.tydic.dict.repository.po.InfoProjectConclusionReqBO;
import com.tydic.dict.service.course.InfoProjectConclusionService;
import com.tydic.dict.service.course.InfoWorkOrderSupportService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.ConclusionEndReqBO;
import com.tydic.dict.service.course.bo.InfoWorkOrderSupportReqBO;
import com.tydic.dict.service.course.bo.InfoWorkOrderSupportRspBO;
import com.tydic.dict.service.course.servDu.InfoprojectConclusionServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @program: markedeve-service-udp
 * @ClassName: InfoWorkOrderSupportServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-11 15:27
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoProjectConclusionServDuImpl implements InfoprojectConclusionServDu {

    @Resource
    private InfoProjectConclusionService infoProjectConclusionService;

    @Override
    public BaseRspBO commitResponsible(InfoProjectConclusionReqBO infoProjectConclusionReqBO) {
        BaseRspBO result = new BaseRspBO();
        try{
            result = infoProjectConclusionService.commitSupport(infoProjectConclusionReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("项目结项commitSupport异常：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return result;
    }

    @Override
    public BaseRspBO conclusionFlowEnd(ConclusionEndReqBO conclusionEndReqBO) {
        BaseRspBO result = new BaseRspBO();
        try{
            result = infoProjectConclusionService.conclusionFlowEnd(conclusionEndReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("项目结项conclusionFlowEnd异常：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return result;
    }
}
