package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoProjectCostBudgetService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.InfoProjectCostBudgetServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @program: markedeve-service-udp
 * @ClassName: InfoProjectCostBudgetServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-22 11:38
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoProjectCostBudgetServDuImpl implements InfoProjectCostBudgetServDu {

    private final InfoProjectCostBudgetService infoProjectCostBudgetService;

    @Override
    public InfoProjectCostBudgetRspBO queryInfoProjectCostBudgetOne(InfoProjectCostBudgetReqBO reqBO) {
        log.info("-------[InfoProjectCostBudgetServDuImpl-queryInfoProjectCostBudgetOne]-------，入参{}", reqBO.toString());
        InfoProjectCostBudgetRspBO rspBO = new InfoProjectCostBudgetRspBO();
        try {
            rspBO = infoProjectCostBudgetService.queryInfoProjectCostBudgetOne(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectCostBudgetServDuImpl-queryInfoProjectCostBudgetOne]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public ProjectBudgetRspBO getInfoProjectCostBudgetLog(ProjectBudgetReqBO reqBO) {
        log.info("-------[InfoProjectCostBudgetServDuImpl-getInfoProjectCostBudgetLog]-------，入参{}", reqBO.toString());
        ProjectBudgetRspBO rspBO = new ProjectBudgetRspBO();
        try {
            rspBO = infoProjectCostBudgetService.getInfoProjectCostBudgetLog(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectCostBudgetServDuImpl-getInfoProjectCostBudgetLog]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoProjectCostBudgetLogRspBO queryInfoProjectCostBudgetLogOne(InfoProjectCostBudgetReqBO reqBO) {
        log.info("-------[InfoProjectCostBudgetServDuImpl-queryInfoProjectCostBudgetLogOne]-------，入参{}", reqBO.toString());
        InfoProjectCostBudgetLogRspBO rspBO = new InfoProjectCostBudgetLogRspBO();
        try {
            rspBO = infoProjectCostBudgetService.queryInfoProjectCostBudgetLogOne(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectCostBudgetServDuImpl-queryInfoProjectCostBudgetLogOne]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
