package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoProjectNodePlanHisSubmitService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.InfoProjectNodePlanHisSubmitServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @program: markedeve-service-udp
 * @ClassName: InfoProjectNodePlanHisSubmitServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-18 15:54
 */
@HTServiceImpl
@Slf4j
public class InfoProjectNodePlanHisSubmitServDuImpl implements InfoProjectNodePlanHisSubmitServDu {
    @Resource
    private InfoProjectNodePlanHisSubmitService infoProjectNodePlanHisSubmitService;
    @Override
    public BaseRspBO doInfoProjectNodePlanHisSubmit(InfoProjectNodePlanHisSubmitReqBO reqBO) {
        log.info("-------[InfoProjectNodePlanHisSubmitServDuImpl-doInfoProjectNodePlanHisSubmit]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoProjectNodePlanHisSubmitService.doInfoProjectNodePlanHisSubmit(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectNodePlanHisSubmitServDuImpl-doInfoProjectNodePlanHisSubmit]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO doInfoProjectNodePlanHisApproveComplete(ProjectKeyNodeApprovalCompletReqBO reqBO) {
        log.info("-------[InfoProjectNodePlanHisSubmitServDuImpl-doInfoProjectNodePlanHisApproveComplete]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoProjectNodePlanHisSubmitService.doInfoProjectNodePlanHisApproveComplete(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectNodePlanHisSubmitServDuImpl-doInfoProjectNodePlanHisApproveComplete]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO doKeyNodeDepartmentLeaderApproval(InfoProjectNodePlanHisSubmitReqBO reqBO) {
        log.info("-------[InfoProjectNodePlanHisSubmitServDuImpl-doKeyNodeDepartmentLeaderApproval]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoProjectNodePlanHisSubmitService.doKeyNodeDepartmentLeaderApproval(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectNodePlanHisSubmitServDuImpl-doKeyNodeDepartmentLeaderApproval]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoProjectNodePlanHisRspBO queryInfoProjectNodePlanHis(InfoProjectNodePlanHisReqBO reqBO) {
        log.info("-------[InfoProjectNodePlanHisSubmitServDuImpl-queryInfoProjectNodePlanHis]-------，入参{}", reqBO.toString());
        InfoProjectNodePlanHisRspBO rspBO = new InfoProjectNodePlanHisRspBO();
        try {
            rspBO = infoProjectNodePlanHisSubmitService.queryInfoProjectNodePlanHis(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectNodePlanHisSubmitServDuImpl-queryInfoProjectNodePlanHis]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
