package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoProjectNodePlanService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoProjectNodePlanReqBO;
import com.tydic.dict.service.course.bo.InfoProjectNodePlanRspBO;
import com.tydic.dict.service.course.servDu.InfoProjectNodePlanServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @program: markedeve-service-udp
 * @ClassName: InfoProjectNodePlanServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-21 11:19
 */

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoProjectNodePlanServDuImpl implements InfoProjectNodePlanServDu {
    private final InfoProjectNodePlanService infoProjectNodePlanService;

    @Override
    public InfoProjectNodePlanRspBO queryInfoProjectNodePlanList(InfoProjectNodePlanReqBO reqBO) {
        log.info("-------[InfoProjectNodePlanServDuImpl-queryInfoProjectNodePlanList]-------，入参{}", reqBO.toString());
        InfoProjectNodePlanRspBO rspBO = new InfoProjectNodePlanRspBO();
        try {
            rspBO = infoProjectNodePlanService.queryInfoProjectNodePlanList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectNodePlanServDuImpl-queryInfoProjectNodePlanList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoProjectNodePlanRspBO queryInfoProjectNodePlanObject(InfoProjectNodePlanReqBO reqBO) {
        log.info("-------[InfoProjectNodePlanServDuImpl-queryInfoProjectNodePlanObject]-------，入参{}", reqBO.toString());
        InfoProjectNodePlanRspBO rspBO = new InfoProjectNodePlanRspBO();
        try {
            rspBO = infoProjectNodePlanService.queryInfoProjectNodePlanObject(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectNodePlanServDuImpl-queryInfoProjectNodePlanObject]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO doJunctionCheck(InfoProjectNodePlanReqBO reqBO) {
        log.info("-------[InfoProjectNodePlanServDuImpl-doJunctionCheck]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoProjectNodePlanService.doJunctionCheck(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectNodePlanServDuImpl-doJunctionCheck]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
