package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoProjectOtherCostService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoProjectOtherCostReqBO;
import com.tydic.dict.service.course.bo.InfoProjectOtherCostRspBO;
import com.tydic.dict.service.course.servDu.InfoProjectOtherCostServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

@HTServiceImpl
@Slf4j
public class InfoProjectOtherCostServDuImpl implements InfoProjectOtherCostServDu {

    @Resource
    private InfoProjectOtherCostService infoProjectOtherCostService;
    @Override
    public InfoProjectOtherCostRspBO queryInfoProjectOtherCostByPage(InfoProjectOtherCostReqBO infoProjectOtherCostReqBO) {
        log.info("-------[InfoProjectOtherCostServDuImpl-queryInfoProjectOtherCostByPage]-------，入参{}", infoProjectOtherCostReqBO.toString());
        InfoProjectOtherCostRspBO result = new InfoProjectOtherCostRspBO();
        try{
            result =infoProjectOtherCostService.queryInfoProjectOtherCostByPage(infoProjectOtherCostReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("queryInfoProjectOtherCostByPage：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectOtherCostServDuImpl-queryInfoProjectOtherCostByPage]-------，出参{}", result.toString());
        return result;
    }

    @Override
    public BaseRspBO addInfoProjectOtherCost(InfoProjectOtherCostReqBO infoProjectOtherCostReqBO) {
        log.info("-------[InfoProjectOtherCostServDuImpl-addInfoProjectOtherCost]-------，入参{}", infoProjectOtherCostReqBO.toString());
        BaseRspBO result = new BaseRspBO();
        try{
            result =infoProjectOtherCostService.addInfoProjectOtherCost(infoProjectOtherCostReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("addInfoProjectOtherCost：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectOtherCostServDuImpl-addInfoProjectOtherCost]-------，出参{}", result.toString());
        return result;
    }

    @Override
    public BaseRspBO modifyInfoProjectOtherCost(InfoProjectOtherCostReqBO infoProjectOtherCostReqBO) {
        log.info("-------[InfoProjectOtherCostServDuImpl-modifyInfoProjectOtherCost]-------，入参{}", infoProjectOtherCostReqBO.toString());
        BaseRspBO result = new BaseRspBO();
        try{
            result =infoProjectOtherCostService.modifyInfoProjectOtherCost(infoProjectOtherCostReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("modifyInfoProjectOtherCost：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectOtherCostServDuImpl-modifyInfoProjectOtherCost]-------，出参{}", result.toString());
        return result;
    }

    @Override
    public BaseRspBO deleteInfoProjectOtherCost(InfoProjectOtherCostReqBO infoProjectOtherCostReqBO) {
        log.info("-------[InfoProjectOtherCostServDuImpl-deleteInfoProjectOtherCost]-------，入参{}", infoProjectOtherCostReqBO.toString());
        BaseRspBO result = new BaseRspBO();
        try{
            result =infoProjectOtherCostService.deleteInfoProjectOtherCost(infoProjectOtherCostReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("deleteInfoProjectOtherCost：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectOtherCostServDuImpl-deleteInfoProjectOtherCost]-------，出参{}", result.toString());
        return result;
    }
}
