package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoProjectTeamService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.InfoProjectTeamServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @program: markedeve-service-udp
 * @ClassName: InfoProjectTeamServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-21 15:41
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoProjectTeamServDuImpl implements InfoProjectTeamServDu {

    private final InfoProjectTeamService infoProjectTeamService;

    @Override
    public BaseRspBO addInfoProjectTeam(InfoProjectTeamReqBO reqBO) {
        log.info("-------[InfoProjectTeamServDuImpl-addInfoProjectTeam]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoProjectTeamService.addInfoProjectTeam(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectTeamServDuImpl-addInfoProjectTeam]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO removeInfoProjectTeam(InfoProjectTeamReqBO reqBO) {
        log.info("-------[InfoProjectTeamServDuImpl-removeInfoProjectTeam]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoProjectTeamService.removeInfoProjectTeam(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectTeamServDuImpl-removeInfoProjectTeam]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoProjectTeamRspBO queryInfoProjectTeamPageList(InfoProjectTeamReqBO reqBO) {
        log.info("-------[InfoProjectTeamServDuImpl-queryInfoProjectTeamPageList]-------，入参{}", reqBO.toString());
        InfoProjectTeamRspBO rspBO = new InfoProjectTeamRspBO();
        try {
            rspBO = infoProjectTeamService.queryInfoProjectTeamPageList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectTeamServDuImpl-queryInfoProjectTeamPageList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public ProjectBudgetRspBO queryInfoProjectTeamLogPageList(ProjectBudgetReqBO reqBO) {
        log.info("-------[InfoProjectTeamServDuImpl-queryInfoProjectTeamLogPageList]-------，入参{}", reqBO.toString());
        ProjectBudgetRspBO rspBO = new ProjectBudgetRspBO();
        try {
            rspBO = infoProjectTeamService.queryInfoProjectTeamLogPageList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectTeamServDuImpl-queryInfoProjectTeamLogPageList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public ProjectBudgetRspBO queryInfoProjectTeamLogPageListByBusiCode(ProjectBudgetReqBO reqBO) {
        log.info("-------[InfoProjectTeamServDuImpl-queryInfoProjectTeamLogPageListByBusiCode]-------，入参{}", reqBO.toString());
        ProjectBudgetRspBO rspBO = new ProjectBudgetRspBO();
        try {
            rspBO = infoProjectTeamService.queryInfoProjectTeamLogPageListByBusiCode(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectTeamServDuImpl-queryInfoProjqueryInfoProjectTeamLogPageListByBusiCodeectTeamLogPageList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public ProjectBudgetRspBO queryInfoProjectTeamPageListByProjectCode(ProjectBudgetReqBO reqBO) {
        log.info("-------[InfoProjectTeamServDuImpl-queryInfoProjectTeamPageListByProjectCode]-------，入参{}", reqBO.toString());
        ProjectBudgetRspBO rspBO = new ProjectBudgetRspBO();
        try {
            rspBO = infoProjectTeamService.queryInfoProjectTeamPageListByProjectCode(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoProjectTeamServDuImpl-queryInfoProjectTeamPageListByProjectCode]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO updateInfoProjectTeam(InfoProjectTeamReqBO reqBO) {
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = infoProjectTeamService.updateInfoProjectTeam(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("updateInfoProjectTeam调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return rspBO;
    }
}
