package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoSoftwareService;
import com.tydic.dict.service.course.bo.InfoDemandTabulationHisRspBO;
import com.tydic.dict.service.course.bo.InfoSoftwareReqBO;
import com.tydic.dict.service.course.bo.InfoSoftwareRspBO;
import com.tydic.dict.service.course.servDu.InfoSoftwareServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @program: markedeve-service-udp
 * @ClassName: InfoSoftwareServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-12 20:14
 */
@HTServiceImpl
@Slf4j
public class InfoSoftwareServDuImpl implements InfoSoftwareServDu {

    @Resource
    private InfoSoftwareService infoSoftwareService;

    @Override
    public InfoSoftwareRspBO queryInfoSoftwarePageList(InfoSoftwareReqBO reqBO) {
        log.info("-------[InfoSoftwareServDuImpl-queryInfoSoftwarePageList]-------，入参{}", reqBO.toString());
        InfoSoftwareRspBO rspBO = new InfoSoftwareRspBO();
        try {
            rspBO = infoSoftwareService.queryInfoSoftwarePageList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoSoftwareServDuImpl-queryInfoSoftwarePageList]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
