package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoSupplierService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoSupplierReqBO;
import com.tydic.dict.service.course.bo.InfoSupplierSelRspBO;
import com.tydic.dict.service.course.servDu.InfoSupplierServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoSupplierServDuImpl implements InfoSupplierServDu {

    @Resource
    InfoSupplierService infoSupplierService;
    @Override
    public BaseRspBO saveInfoSupplier(InfoSupplierReqBO reqBO) {
        log.info("-------[InfoSupplierServDuImpl-saveInfoSupplier]-------，入参{}", reqBO.toString());
        BaseRspBO  rspBO = new BaseRspBO ();

        try{
            rspBO =infoSupplierService.saveInfoSupplier(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("saveInfoOutsourcingFrame：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoSupplierServDuImpl-saveInfoSupplier]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoSupplierSelRspBO queryInfoSupplierCondition(InfoSupplierReqBO reqBO) {
        log.info("-------[InfoSupplierServDuImpl-queryInfoSupplierCondition]-------，入参{}", reqBO.toString());
        InfoSupplierSelRspBO  rspBO = new InfoSupplierSelRspBO ();

        try{
            rspBO =infoSupplierService.queryInfoSupplierCondition(reqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("saveInfoOutsourcingFrame：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoSupplierServDuImpl-queryInfoSupplierCondition]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
