package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoTaskSettlementFlowService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoTaskSettlementFlowReqBO;
import com.tydic.dict.service.course.bo.InfoTaskSettlementRspBO;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.InfoTaskSettlementFlowServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description:
 * @Author: xsl
 * @Date: 2024/6/27 16:38
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoTaskSettlementFlowServDuImpl implements InfoTaskSettlementFlowServDu {

    private final InfoTaskSettlementFlowService infoTaskSettlementFlowService;

    @Override
    public BaseRspBO submitInfoTaskSettlement(InfoTaskSettlementFlowReqBO reqBO) {
        try {
            return infoTaskSettlementFlowService.submitInfoTaskSettlement(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("submitInfoTaskSettlement调用异常：{}",e.getMessage());
            InfoTaskSettlementRspBO rspBO = new InfoTaskSettlementRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1 + "：" + e.getMessage());
            return rspBO;
        }
    }

    @Override
    public BaseRspBO deductionInfoTaskSettlement(InfoTaskSettlementFlowReqBO reqBO) {
        try {
            return infoTaskSettlementFlowService.deductionInfoTaskSettlement(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("deductionInfoTaskSettlement调用异常：{}",e.getMessage());
            InfoTaskSettlementRspBO rspBO = new InfoTaskSettlementRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public BaseRspBO endInfoTaskSettlement(InfoTaskSettlementFlowReqBO reqBO) {
        try {
            return infoTaskSettlementFlowService.endInfoTaskSettlement(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("endInfoTaskSettlement调用异常：{}",e.getMessage());
            InfoTaskSettlementRspBO rspBO = new InfoTaskSettlementRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1 + "：" + e.getMessage());
            return rspBO;
        }
    }

    @Override
    public InfoTaskSettlementRspBO infoTaskSettlementDetails(InfoTaskSettlementFlowReqBO reqBO) {
        try {
            return infoTaskSettlementFlowService.infoTaskSettlementDetails(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("infoTaskSettlementDetails调用异常：{}",e.getMessage());
            InfoTaskSettlementRspBO rspBO = new InfoTaskSettlementRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoTaskSettlementRspBO evaluateFlagOneCostDeduction(InfoTaskSettlementFlowReqBO reqBO) {
        try {
            return infoTaskSettlementFlowService.evaluateFlagOneCostDeduction(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("evaluateFlagOneCostDeduction调用异常：{}",e.getMessage());
            InfoTaskSettlementRspBO rspBO = new InfoTaskSettlementRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }
}
