package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoTaskSettlementService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoTaskSettlementReqBO;
import com.tydic.dict.service.course.bo.InfoTaskSettlementRspBO;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.InfoTaskSettlementServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description:
 * @Author: xsl
 * @Date: 2024/6/26 16:56
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoTaskSettlementServDuImpl implements InfoTaskSettlementServDu {
    private final InfoTaskSettlementService infoTaskSettlementService;
    @Override
    public InfoTaskSettlementRspBO queryInfoTaskSettlementAttendance(InfoTaskSettlementReqBO reqBO) {
        try {
            return infoTaskSettlementService.queryInfoTaskSettlementAttendance(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("queryInfoTaskSettlementAttendance调用异常：{}",e.getMessage());
            InfoTaskSettlementRspBO rspBO = new InfoTaskSettlementRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public BaseRspBO deleteInfoTaskSettlementAttendance(InfoTaskSettlementReqBO reqBO) {
        try {
            return infoTaskSettlementService.deleteInfoTaskSettlementAttendance(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("deleteInfoTaskSettlementAttendance调用异常：{}",e.getMessage());
            BaseRspBO rspBO = new BaseRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public BaseRspBO insertInfoTaskSettlementStorage(InfoTaskSettlementReqBO reqBO) {
        try {
            return infoTaskSettlementService.insertInfoTaskSettlementStorage(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("insertInfoTaskSettlementStorage调用异常：{}",e.getMessage());
            BaseRspBO rspBO = new BaseRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public BaseRspBO updateInfoTaskSettlementStorage(InfoTaskSettlementReqBO reqBO) {
        try {
            return infoTaskSettlementService.updateInfoTaskSettlementStorage(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("updateInfoTaskSettlementStorage调用异常：{}",e.getMessage());
            BaseRspBO rspBO = new BaseRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoTaskSettlementRspBO queryInfoTaskSettlementStorage(InfoTaskSettlementReqBO reqBO) {
        try {
            return infoTaskSettlementService.queryInfoTaskSettlementStorage(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("queryInfoTaskSettlementStorage调用异常：{}",e.getMessage());
            InfoTaskSettlementRspBO rspBO = new InfoTaskSettlementRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoTaskSettlementRspBO queryInfoTaskSettlementGrade(InfoTaskSettlementReqBO reqBO) {
        try {
            return infoTaskSettlementService.queryInfoTaskSettlementGrade(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("queryInfoTaskSettlementGrade调用异常：{}",e.getMessage());
            InfoTaskSettlementRspBO rspBO = new InfoTaskSettlementRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public BaseRspBO insertInfoTaskSettlementDeduction(InfoTaskSettlementReqBO reqBO) {
        try {
            return infoTaskSettlementService.insertInfoTaskSettlementDeduction(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("insertInfoTaskSettlementDeduction调用异常：{}",e.getMessage());
            BaseRspBO rspBO = new BaseRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public BaseRspBO updateInfoTaskSettlementDeduction(InfoTaskSettlementReqBO reqBO) {
        try {
            return infoTaskSettlementService.updateInfoTaskSettlementDeduction(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("updateInfoTaskSettlementDeduction调用异常：{}",e.getMessage());
            BaseRspBO rspBO = new BaseRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoTaskSettlementRspBO queryInfoTaskSettlementDeduction(InfoTaskSettlementReqBO reqBO) {
        try {
            return infoTaskSettlementService.queryInfoTaskSettlementDeduction(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("queryInfoTaskSettlementDeduction调用异常：{}",e.getMessage());
            InfoTaskSettlementRspBO rspBO = new InfoTaskSettlementRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoTaskSettlementRspBO queryInfoTaskSettlement(InfoTaskSettlementReqBO reqBO) {
        try {
            return infoTaskSettlementService.queryInfoTaskSettlement(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("queryInfoTaskSettlement调用异常：{}",e.getMessage());
            InfoTaskSettlementRspBO rspBO = new InfoTaskSettlementRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public InfoTaskSettlementRspBO updateTaskSettlement(InfoTaskSettlementReqBO reqBO) {
        try {
            return infoTaskSettlementService.updateTaskSettlement(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("updateTaskSettlement调用异常：{}",e.getMessage());
            InfoTaskSettlementRspBO rspBO = new InfoTaskSettlementRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }
}
