package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoWorkOrderCostBudgetService;
import com.tydic.dict.service.course.bo.InfoWorkOrderCostBudgetReqBO;
import com.tydic.dict.service.course.bo.InfoWorkOrderCostBudgetRspBO;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.InfoWorkOrderCostBudgetServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @program: markedeve-service-udp
 * @ClassName: InfoWorkOrderCostBudgetServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-26 20:36
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoWorkOrderCostBudgetServDuImpl implements InfoWorkOrderCostBudgetServDu {

    private final InfoWorkOrderCostBudgetService infoWorkOrderCostBudgetService;

    @Override
    public InfoWorkOrderCostBudgetRspBO queryInfoWorkOrderCostBudgetOne(InfoWorkOrderCostBudgetReqBO reqBO) {
        log.info("-------[InfoWorkOrderCostBudgetServDuImpl-queryInfoWorkOrderCostBudgetOne]-------，入参{}", reqBO.toString());
        InfoWorkOrderCostBudgetRspBO rspBO = new InfoWorkOrderCostBudgetRspBO();
        try {
            rspBO = infoWorkOrderCostBudgetService.queryInfoWorkOrderCostBudgetOne(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoWorkOrderCostBudgetServDuImpl-queryInfoWorkOrderCostBudgetOne]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
