package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoWorkOrderSupportService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.InfoWorkOrderSupportServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @program: markedeve-service-udp
 * @ClassName: InfoWorkOrderSupportServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-11 15:27
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoWorkOrderSupportServDuImpl implements InfoWorkOrderSupportServDu {

    @Resource
    private InfoWorkOrderSupportService infoWorkOrderSupportService;
    @Override
    public InfoWorkOrderSupportRspBO queryInfoWorkOrderSupportPageList(InfoWorkOrderSupportReqBO reqBO) {
        log.info("-------[InfoWorkOrderSupportServDuImpl-queryInfoWorkOrderSupportPageList]-------，入参{}", reqBO.toString());
        InfoWorkOrderSupportRspBO rspBO = new InfoWorkOrderSupportRspBO();
        try {
            rspBO = infoWorkOrderSupportService.queryInfoWorkOrderSupportPageList(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoWorkOrderSupportServDuImpl-queryInfoWorkOrderSupportPageList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO commitSupport(InfoWorkOrderSupportReqBO infoWorkOrderSupportReqBO0) {
        BaseRspBO result = new BaseRspBO();
        try{
            result = infoWorkOrderSupportService.commitSupport(infoWorkOrderSupportReqBO0);
        }catch (Exception e){
            e.printStackTrace();
            log.error("commitSupport异常：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return result;
    }

    @Override
    public BaseRspBO saveSupport(InfoWorkOrderSupportReqBO infoWorkOrderSupportReqBO0) {
        BaseRspBO result = new BaseRspBO();
        try{
            result = infoWorkOrderSupportService.saveSupport(infoWorkOrderSupportReqBO0);
        }catch (Exception e){
            e.printStackTrace();
            log.error("saveSupport异常：" + e.getMessage());
            result.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return result;
    }

    @Override
    public InfoWorkOrderSupportRspBO querySupportDetails(InfoWorkOrderSupportReqBO infoWorkOrderSupportReqBO0) {
        InfoWorkOrderSupportRspBO rspBO = new InfoWorkOrderSupportRspBO();
        try {
            rspBO = infoWorkOrderSupportService.querySupportDetails(infoWorkOrderSupportReqBO0);
        } catch (Exception e) {
            rspBO.setRespCode(com.tydic.dyc.base.constants.BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return rspBO;
    }
}
