package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoWorkOrderSupportSituationService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoWorkOrderSupportSituationBO;
import com.tydic.dict.service.course.bo.InfoWorkOrderSupportSituationReqBO;
import com.tydic.dict.service.course.bo.InfoWorkOrderSupportSituationRspBO;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.InfoWorkOrderSupportSituationServDu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;
import java.util.List;

@HTServiceImpl
@Slf4j
public class InfoWorkOrderSupportSituationServDuImpl implements InfoWorkOrderSupportSituationServDu {
    @Resource
    private  InfoWorkOrderSupportSituationService infoWorkOrderSupportSituationService;
    @Override
    public BaseRspBO submitSupportSituation(InfoWorkOrderSupportSituationBO infoWorkOrderSupportSituationBO) {
        BaseRspBO result = new BaseRspBO();
        try{
            result = infoWorkOrderSupportSituationService.submitSupportSituation(infoWorkOrderSupportSituationBO);
        }catch (Exception e){
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
        }
        return result;
    }

    @Override
    public InfoWorkOrderSupportSituationRspBO infoWorkOrderSupportSituationDetails(InfoWorkOrderSupportSituationReqBO infoWorkOrderSupportSituationReqBO) {
        InfoWorkOrderSupportSituationRspBO result = new InfoWorkOrderSupportSituationRspBO();
        try{
            result = infoWorkOrderSupportSituationService.infoWorkOrderSupportSituationDetails(infoWorkOrderSupportSituationReqBO);
        }catch (Exception e){
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
        }
        return result;
    }
}
