package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.InfoWorkOrderTeamService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.InfoWorkOrderTeamServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class InfoWorkOrderTeamServDuImpl implements InfoWorkOrderTeamServDu {
    private final InfoWorkOrderTeamService infoWorkOrderTeamService;
    @Override
    public BaseRspBO addTeam(InfoWorkOrderTeamBO infoWorkOrderTeamBO) {
        BaseRspBO result = new BaseRspBO();
        try{
            result = infoWorkOrderTeamService.addTeam(infoWorkOrderTeamBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("addTeam调用service异常：" + e.getMessage());
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return result;
    }

    @Override
    public BaseRspBO deleteTeam(InfoWorkOrderTeamBO infoWorkOrderTeamBO) {
        BaseRspBO result = new BaseRspBO();
        try{
            result = infoWorkOrderTeamService.deleteTeam(infoWorkOrderTeamBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("deleteTeam调用service异常：" + e.getMessage());
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return result;
    }

    @Override
    public BaseRspBO approvalCommit(TeamFlowCommitReqBO teamFlowCommitReqBO) {
        BaseRspBO result = new BaseRspBO();
        try{
            result = infoWorkOrderTeamService.approvalCommit(teamFlowCommitReqBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("approvalCommit调用service异常：" + e.getMessage());
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return result;
    }

    @Override
    public InfoWorkOrderTeamRspBO queryInfoWorkOrderTeamPageList(InfoWorkOrderTeamBO infoWorkOrderTeamBO) {
        log.info("-------[InfoWorkOrderTeamServDuImpl-queryInfoWorkOrderTeamPageList]-------，入参{}", infoWorkOrderTeamBO.toString());
        InfoWorkOrderTeamRspBO rspBO = new InfoWorkOrderTeamRspBO();
        try {
            rspBO = infoWorkOrderTeamService.queryInfoWorkOrderTeamPageList(infoWorkOrderTeamBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("queryInfoWorkOrderTeamPageList调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[InfoWorkOrderTeamServDuImpl-queryInfoWorkOrderTeamPageList]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO updateTeam(InfoWorkOrderTeamBO infoWorkOrderTeamBO) {
        BaseRspBO result = new BaseRspBO();
        try{
            result = infoWorkOrderTeamService.updateTeam(infoWorkOrderTeamBO);
        }catch (Exception e){
            e.printStackTrace();
            log.error("updateTeam调用service异常：" + e.getMessage());
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return result;
    }
}
