package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.LogAuditTodoService;
import com.tydic.dict.service.course.bo.LogAuditTodoBO;
import com.tydic.dict.service.course.bo.LogAuditTodoReqBO;
import com.tydic.dict.service.course.bo.LogAuditTodoRspBO;
import com.tydic.dict.service.course.servDu.LogAuditTodoServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class LogAuditTodoServDuImpl implements LogAuditTodoServDu {
    private final LogAuditTodoService logAuditTodoService;
    @Override
    public LogAuditTodoRspBO queryByName(LogAuditTodoBO logAuditTodoBO0) {
        return logAuditTodoService.queryByName(logAuditTodoBO0);
    }

    @Override
    public LogAuditTodoRspBO queryByCondition(LogAuditTodoBO logAuditTodoBO) {
        LogAuditTodoRspBO rspBO = new LogAuditTodoRspBO();
        try {
            return logAuditTodoService.queryByCondition(logAuditTodoBO);
        }
        catch (Exception e){
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return rspBO;
    }

    @Override
    public LogAuditTodoRspBO readLogAuditTodo(LogAuditTodoReqBO reqBO) {
        LogAuditTodoRspBO rspBO = new LogAuditTodoRspBO();
        try {
            return logAuditTodoService.readLogAuditTodo(reqBO);
        }
        catch (Exception e){
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return rspBO;
    }
}
