package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.LogAuditTodoService;
import com.tydic.dict.service.course.bo.LogAuditTodoReqBO;
import com.tydic.dict.service.course.bo.LogAuditTodoRspBO;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.LogAuditTodoServiceDu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: wangchao
 * @create: 2023-10-17 16:24
 **/

@Service
@Slf4j
public class LogAuditTodoServiceDuImpl implements LogAuditTodoServiceDu {

    @Autowired
    private LogAuditTodoService logAuditTodoService;

    @Override
    public LogAuditTodoRspBO insertLogAuditTodo(LogAuditTodoReqBO reqBO) {
        try {
            return logAuditTodoService.insertLogAuditTodo(reqBO);
        } catch (Exception e) {
            LogAuditTodoRspBO rspBO = new LogAuditTodoRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL_1);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

    @Override
    public LogAuditTodoRspBO updateLogAuditTodo(LogAuditTodoReqBO reqBO) {
        try {
            return logAuditTodoService.updateLogAuditTodo(reqBO);
        } catch (Exception e) {
            LogAuditTodoRspBO rspBO = new LogAuditTodoRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL_1);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1);
            return rspBO;
        }
    }

}
