package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.OpenSourceSoftwareManagementService;
import com.tydic.dict.service.course.bo.InfoDemandTabulationRspBO;
import com.tydic.dict.service.course.bo.OpenSourceSoftwareManagementReqBO;
import com.tydic.dict.service.course.bo.OpenSourceSoftwareManagementRspBO;
import com.tydic.dict.service.course.servDu.OpenSourceSoftwareManagementServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @program: markedeve-service-udp
 * @ClassName: OpenSourceSoftwareManagementServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-02-28 17:26
 */

@HTServiceImpl
@Slf4j
public class OpenSourceSoftwareManagementServDuImpl implements OpenSourceSoftwareManagementServDu {

    @Resource
    private OpenSourceSoftwareManagementService openSourceSoftwareManagementService;

    @Override
    public OpenSourceSoftwareManagementRspBO queryInfoSoftwareAndUse(OpenSourceSoftwareManagementReqBO reqBO) {
        log.info("-------[OpenSourceSoftwareManagementServDuImpl-queryInfoSoftwareAndUse]-------，入参{}", reqBO.toString());
        OpenSourceSoftwareManagementRspBO rspBO = new OpenSourceSoftwareManagementRspBO();
        try {
            rspBO = openSourceSoftwareManagementService.queryInfoSoftwareAndUse(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[OpenSourceSoftwareManagementServDuImpl-queryInfoSoftwareAndUse]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
