package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.CodeTaskAssignRuleService;
import com.tydic.dict.service.course.bo.CodeTaskAssignRuleReqBO;
import com.tydic.dict.service.course.bo.CodeTaskAssignRuleRspBO;
import com.tydic.dict.service.course.servDu.OsworkflowUserServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description:
 * @Author: xsl
 * @Date: 2024/3/11 14:05
 */
@HTServiceImpl
@Slf4j
public class OsworkflowUserServDuImpl implements OsworkflowUserServDu {
    @Autowired
    private CodeTaskAssignRuleService codeTaskAssignRuleService;
    @Override
    public CodeTaskAssignRuleRspBO getTacheUser(CodeTaskAssignRuleReqBO codeTaskAssignRuleReqBO0) {
        return null;
    }

    @Override
    public CodeTaskAssignRuleRspBO getOsworkflowUser(CodeTaskAssignRuleReqBO reqBO) {
        log.info("-------[OsworkflowUserServDuImpl-getOsworkflowUser]-------，入参{}", reqBO.toString());
        CodeTaskAssignRuleRspBO rspBO = new CodeTaskAssignRuleRspBO();
        try {
            rspBO = codeTaskAssignRuleService.queryTaskAssignUserInfo(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[OsworkflowUserServDuImpl-getOsworkflowUser]-------，出参{}", rspBO.toString());

        return rspBO;
    }
}
