package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.ProcessNotLogicallyService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.ProcessNotLogicallyServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @program: markedeve-service-udp
 * @ClassName: ProcessNotLogicallyServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-06 15:23
 */
@HTServiceImpl
@Slf4j
public class ProcessNotLogicallyServDuImpl implements ProcessNotLogicallyServDu {

    @Resource
    private ProcessNotLogicallyService processNotLogicallyService;

    @Override
    public BaseRspBO doProcessNotLogicallyUnify(ProcessNotLogicallyReqBO reqBO) {
        log.info("-------[ProcessNotLogicallyServDuImpl-doProcessNotLogically]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = processNotLogicallyService.doProcessNotLogicallyUnify(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[ProcessNotLogicallyServDuImpl-doProcessNotLogically]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public CodeOperCodeRspBO queryCodeOperCodeInfo(CodeOperCodeReqBO reqBO) {
        CodeOperCodeRspBO rspBO = new CodeOperCodeRspBO();
        try {
            rspBO = processNotLogicallyService.queryCodeOperCodeInfo(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return rspBO;
    }
}
