package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.ProductIndustryAndMainService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.ProductIndustryAndMainServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class ProductIndustryAndMainServDuImpl implements ProductIndustryAndMainServDu {
    private final ProductIndustryAndMainService productIndustryAndMainService;
    @Override
    public CodeProductIndustryRspBO queryIndustry(CodeProductIndustryBO codeProductIndustryBO0) {
        try{
            return productIndustryAndMainService.queryIndustry(codeProductIndustryBO0);
        }catch (Exception e){
            CodeProductIndustryRspBO result = new CodeProductIndustryRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public InfoProductIndustryRlationRspBO queryProduct(InfoProductIndustryRelationBO infoProductIndustryRelationBO0) {
        try{
            return productIndustryAndMainService.queryProduct(infoProductIndustryRelationBO0);
        }catch (Exception e){
            InfoProductIndustryRlationRspBO result = new InfoProductIndustryRlationRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public InfoMainProductLsRspBO queryMainProduct(InfoMainProductLsBO infoMainProductLsBO0) {
        try{
            return productIndustryAndMainService.queryMainProduct(infoMainProductLsBO0);
        }catch (Exception e){
            InfoMainProductLsRspBO result = new InfoMainProductLsRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public BaseRspBO markingProduct(InfoProductIndustryRelationBO infoProductIndustryRelationBO0) {
        try{
            return productIndustryAndMainService.markingProduct(infoProductIndustryRelationBO0);
        }catch (Exception e){
            BaseRspBO result = new BaseRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public BaseRspBO mainProductMarking(InfoMainProductLsBO infoMainProductLsBO0) {
        try{
            return productIndustryAndMainService.mainProductMarking(infoMainProductLsBO0);
        }catch (Exception e){
            BaseRspBO result = new BaseRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }
}
