package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.ProjectCostManageService;
import com.tydic.dict.service.course.bo.InfoDemandTaskRspBO;
import com.tydic.dict.service.course.bo.InfoWorkOrderSupportRspBO;
import com.tydic.dict.service.course.bo.ProjectCostManageReqBO;
import com.tydic.dict.service.course.bo.ProjectCostManageRspBO;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.ProjectCostManageServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description: 项目成本管理服务
 * @Author: xsl
 * @Date: 2024/8/1 14:37
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class ProjectCostManageServDuImpl implements ProjectCostManageServDu {

    private final ProjectCostManageService projectCostManageService;

    @Override
    public ProjectCostManageRspBO getProjectCostManageInfo(ProjectCostManageReqBO projectCostManageReqBO) {
        try{
            return projectCostManageService.getProjectCostManageInfo(projectCostManageReqBO);
        }catch (Exception e){
            ProjectCostManageRspBO rspBO = new ProjectCostManageRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1 + ":" + e.getMessage());
            return rspBO;
        }
    }

    @Override
    public ProjectCostManageRspBO getLatestNodeInfo(ProjectCostManageReqBO projectCostManageReqBO) {
        try{
            return projectCostManageService.getLatestNodeInfo(projectCostManageReqBO);
        }catch (Exception e){
            ProjectCostManageRspBO rspBO = new ProjectCostManageRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1 + ":" + e.getMessage());
            return rspBO;
        }
    }

    @Override
    public InfoDemandTaskRspBO getOutsourceInfo(ProjectCostManageReqBO projectCostManageReqBO) {
        try{
            return projectCostManageService.getOutsourceInfo(projectCostManageReqBO);
        }catch (Exception e){
            InfoDemandTaskRspBO rspBO = new InfoDemandTaskRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1 + ":" + e.getMessage());
            return rspBO;
        }
    }

    @Override
    public InfoWorkOrderSupportRspBO getInfoWorkOrderSupportPageList(ProjectCostManageReqBO projectCostManageReqBO) {
        try{
            return projectCostManageService.getInfoWorkOrderSupportPageList(projectCostManageReqBO);
        }catch (Exception e){
            InfoWorkOrderSupportRspBO rspBO = new InfoWorkOrderSupportRspBO();
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL_1 + ":" + e.getMessage());
            return rspBO;
        }
    }
}
