package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.ProjectInitiationService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.ProjectInitiationSaveReqBO;
import com.tydic.dict.service.course.servDu.ProjectInitiationServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @program: markedeve-service-udp
 * @ClassName: ProjectInitiationServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-05 11:33
 */

@HTServiceImpl
@Slf4j
public class ProjectInitiationServDuImpl implements ProjectInitiationServDu {

    @Resource
    private ProjectInitiationService projectInitiationService;

    @Override
    public BaseRspBO saveProjectInitiation(ProjectInitiationSaveReqBO reqBO) {
        log.info("-------[ProjectInitiationServDuImpl-saveProjectInitiation]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = projectInitiationService.saveProjectInitiation(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[ProjectInitiationServDuImpl-saveProjectInitiation]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public BaseRspBO projectApprovalSubmit(ProjectInitiationSaveReqBO reqBO) {
        log.info("-------[ProjectInitiationServDuImpl-projectApprovalSubmit]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = projectInitiationService.projectApprovalSubmit(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[ProjectInitiationServDuImpl-projectApprovalSubmit]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
